/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.project.runconfigs;

import java.io.File;
import org.netbeans.modules.php.project.util.PhpProjectUtils;

/**
 * Base class for run configs with index file.
 */
abstract class BaseRunConfig<T extends BaseRunConfig<?>> {

    protected File indexParentDir;
    protected String indexRelativePath;
    protected String arguments;


    BaseRunConfig() {
    }

    //~ Methods

    public File getIndexFile() {
        return PhpProjectUtils.resolveFile(indexParentDir, indexRelativePath);
    }

    //~ Getters & setters

    public String getArguments() {
        return arguments;
    }

    // XXX is there a better way?
    @SuppressWarnings("unchecked")
    public T setArguments(String arguments) {
        this.arguments = arguments;
        return (T) this;
    }

    public File getIndexParentDir() {
        return indexParentDir;
    }

    @SuppressWarnings("unchecked")
    public T setIndexParentDir(File indexParentDir) {
        this.indexParentDir = indexParentDir;
        return (T) this;
    }

    public String getIndexRelativePath() {
        return indexRelativePath;
    }

    @SuppressWarnings("unchecked")
    public T setIndexRelativePath(String indexRelativePath) {
        this.indexRelativePath = indexRelativePath;
        return (T) this;
    }

}
