/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.renderkit.html.util.JavascriptContext;
import org.apache.myfaces.util.lang.StringUtils;

public class ClientBehaviorRendererUtils {
    private static final String SB_ESCAPE_JS_FOR_CHAIN = ClientBehaviorRendererUtils.class.getName() + "#ESCAPE_JS_FOR_CHAIN";

    public static void decodeClientBehaviors(FacesContext facesContext, UIComponent component) {
        block7: {
            String item;
            List clientBehaviorList;
            Map paramMap;
            String behaviorEventName;
            if (!(component instanceof ClientBehaviorHolder)) {
                return;
            }
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)component;
            Map clientBehaviors = clientBehaviorHolder.getClientBehaviors();
            if (clientBehaviors == null || clientBehaviors.isEmpty() || (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("jakarta.faces.behavior.event")) == null || (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) == null || clientBehaviorList.isEmpty()) break block7;
            String sourceId = (String)paramMap.get("jakarta.faces.source");
            String componentClientId = component.getClientId(facesContext);
            String clientId = sourceId;
            if (sourceId.startsWith(componentClientId) && sourceId.length() > componentClientId.length() && StringUtils.isInteger(item = sourceId.substring(componentClientId.length() + 1))) {
                clientId = componentClientId;
            }
            if (component.getClientId(facesContext).equals(clientId)) {
                if (clientBehaviorList instanceof RandomAccess) {
                    int size = clientBehaviorList.size();
                    for (int i = 0; i < size; ++i) {
                        ClientBehavior clientBehavior = (ClientBehavior)clientBehaviorList.get(i);
                        clientBehavior.decode(facesContext, component);
                    }
                } else {
                    for (ClientBehavior clientBehavior : clientBehaviorList) {
                        clientBehavior.decode(facesContext, component);
                    }
                }
            }
        }
    }

    public static boolean hasClientBehavior(String eventName, Map<String, List<ClientBehavior>> behaviors) {
        if (behaviors == null) {
            return false;
        }
        return behaviors.get(eventName) != null;
    }

    public static Collection<ClientBehaviorContext.Parameter> getClientBehaviorContextParameters(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<ClientBehaviorContext.Parameter> paramList = new ArrayList<ClientBehaviorContext.Parameter>(params.size());
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            paramList.add(new ClientBehaviorContext.Parameter(paramEntry.getKey(), (Object)paramEntry.getValue()));
        }
        return paramList;
    }

    private static boolean getClientBehaviorScript(FacesContext facesContext, MyfacesConfig config, UIComponent uiComponent, String sourceId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, JavascriptContext target, Collection<ClientBehaviorContext.Parameter> params) {
        boolean renderClientBehavior;
        if (!(uiComponent instanceof ClientBehaviorHolder)) {
            target.append("");
            return false;
        }
        boolean bl = renderClientBehavior = clientBehaviors != null && clientBehaviors.size() > 0;
        if (!renderClientBehavior) {
            target.append("");
            return false;
        }
        List<ClientBehavior> attachedEventBehaviors = clientBehaviors.get(eventName);
        if (attachedEventBehaviors == null || attachedEventBehaviors.isEmpty()) {
            target.append("");
            return false;
        }
        ClientBehaviorContext context = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)uiComponent, (String)eventName, (String)sourceId, params);
        boolean submitting = false;
        if (attachedEventBehaviors instanceof RandomAccess) {
            int size = attachedEventBehaviors.size();
            for (int i = 0; i < size; ++i) {
                ClientBehavior clientBehavior = attachedEventBehaviors.get(i);
                submitting = ClientBehaviorRendererUtils.appendClientBehaviourScript(facesContext, target, context, submitting, i < size - 1, clientBehavior, config);
            }
        } else {
            Iterator<ClientBehavior> clientIterator = attachedEventBehaviors.iterator();
            while (clientIterator.hasNext()) {
                ClientBehavior clientBehavior = clientIterator.next();
                submitting = ClientBehaviorRendererUtils.appendClientBehaviourScript(facesContext, target, context, submitting, clientIterator.hasNext(), clientBehavior, config);
            }
        }
        return submitting;
    }

    private static boolean appendClientBehaviourScript(FacesContext facesContext, JavascriptContext target, ClientBehaviorContext context, boolean submitting, boolean hasNext, ClientBehavior clientBehavior, MyfacesConfig config) {
        String script = clientBehavior.getScript(context);
        if (script != null) {
            ClientBehaviorRendererUtils.addFunction(facesContext, script, target, config);
            if (hasNext) {
                target.append(", ");
            }
            if (!submitting) {
                submitting = clientBehavior.getHints().contains(ClientBehaviorHint.SUBMITTING);
            }
        }
        return submitting;
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String eventName, Collection<ClientBehaviorContext.Parameter> params, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        return ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, null, eventName, params, clientBehaviors, userEventCode, serverEventCode);
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String sourceId, String eventName, Collection<ClientBehaviorContext.Parameter> params, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        int size;
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext);
        ArrayList<String> functions = new ArrayList<String>(3);
        if (StringUtils.isNotBlank(userEventCode)) {
            ClientBehaviorRendererUtils.addFunction(facesContext, userEventCode, functions, config);
        }
        JavascriptContext chainContext = new JavascriptContext();
        JavascriptContext behaviorContext = new JavascriptContext();
        ClientBehaviorRendererUtils.getClientBehaviorScript(facesContext, config, uiComponent, sourceId, eventName, clientBehaviors, behaviorContext, params);
        String behaviorScript = behaviorContext.toString();
        if (StringUtils.isNotBlank(behaviorScript)) {
            functions.add(behaviorScript);
        }
        if (StringUtils.isNotBlank(serverEventCode)) {
            ClientBehaviorRendererUtils.addFunction(facesContext, serverEventCode, functions, config);
        }
        if ((size = functions.size()) > 0) {
            if (sourceId == null) {
                chainContext.append("faces.util.chain(this, event,");
            } else {
                chainContext.append("faces.util.chain(document.getElementById('" + sourceId + "'), event,");
            }
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    chainContext.append(", ");
                }
                chainContext.append((String)functions.get(i));
            }
            chainContext.append(");");
        }
        return chainContext.toString();
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String eventName1, Collection<ClientBehaviorContext.Parameter> params1, String eventName2, Collection<ClientBehaviorContext.Parameter> params2, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        return ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, null, eventName1, params1, eventName2, params2, clientBehaviors, userEventCode, serverEventCode);
    }

    public static String buildBehaviorChain(FacesContext facesContext, UIComponent uiComponent, String sourceId, String eventName1, Collection<ClientBehaviorContext.Parameter> params1, String eventName2, Collection<ClientBehaviorContext.Parameter> params2, Map<String, List<ClientBehavior>> clientBehaviors, String userEventCode, String serverEventCode) {
        int size;
        String behaviorScript2;
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(facesContext);
        ArrayList<String> functions = new ArrayList<String>(3);
        if (StringUtils.isNotBlank(userEventCode)) {
            ClientBehaviorRendererUtils.addFunction(facesContext, userEventCode, functions, config);
        }
        JavascriptContext chainContext = new JavascriptContext();
        JavascriptContext behaviorContext1 = new JavascriptContext();
        boolean submitting1 = ClientBehaviorRendererUtils.getClientBehaviorScript(facesContext, config, uiComponent, sourceId, eventName1, clientBehaviors, behaviorContext1, params1);
        JavascriptContext behaviorContext2 = new JavascriptContext();
        boolean submitting2 = ClientBehaviorRendererUtils.getClientBehaviorScript(facesContext, config, uiComponent, sourceId, eventName2, clientBehaviors, behaviorContext2, params2);
        boolean submitting = submitting1 || submitting2;
        String behaviorScript1 = behaviorContext1.toString();
        if (StringUtils.isNotBlank(behaviorScript1)) {
            functions.add(behaviorScript1);
        }
        if (StringUtils.isNotBlank(behaviorScript2 = behaviorContext2.toString())) {
            functions.add(behaviorScript2);
        }
        if (StringUtils.isNotBlank(serverEventCode)) {
            ClientBehaviorRendererUtils.addFunction(facesContext, serverEventCode, functions, config);
        }
        if ((size = functions.size()) > 0) {
            if (!submitting) {
                chainContext.append("return ");
            }
            if (sourceId == null) {
                chainContext.append("faces.util.chain(this, event,");
            } else {
                chainContext.append("faces.util.chain(document.getElementById('" + sourceId + "'), event,");
            }
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    chainContext.append(", ");
                }
                chainContext.append((String)functions.get(i));
            }
            chainContext.append(");");
            if (submitting) {
                chainContext.append(" return false;");
            }
        }
        return chainContext.toString();
    }

    public static String escapeJavaScriptForChain(FacesContext facesContext, String javaScript) {
        StringBuilder out = null;
        for (int pos = 0; pos < javaScript.length(); ++pos) {
            char c = javaScript.charAt(pos);
            if (c == '\\' || c == '\'') {
                if (out == null) {
                    out = SharedStringBuilder.get((FacesContext)facesContext, (String)SB_ESCAPE_JS_FOR_CHAIN, (int)(javaScript.length() + 8));
                    if (pos > 0) {
                        out.append(javaScript, 0, pos);
                    }
                }
                out.append('\\');
            }
            if (out == null) continue;
            out.append(c);
        }
        if (out == null) {
            return javaScript;
        }
        return out.toString();
    }

    private static void addFunction(FacesContext facesContext, String function, List<String> functions, MyfacesConfig config) {
        if (StringUtils.isNotBlank(function)) {
            if (config.isRenderClientBehaviorScriptsAsString()) {
                functions.add("'" + ClientBehaviorRendererUtils.escapeJavaScriptForChain(facesContext, function) + "'");
            } else {
                functions.add("function(event){" + function + "}");
            }
        }
    }

    private static void addFunction(FacesContext facesContext, String function, JavascriptContext target, MyfacesConfig config) {
        if (StringUtils.isNotBlank(function)) {
            if (config.isRenderClientBehaviorScriptsAsString()) {
                target.append('\'');
                target.append(ClientBehaviorRendererUtils.escapeJavaScriptForChain(facesContext, function));
                target.append('\'');
            } else {
                target.append("function(event){");
                target.append(function);
                target.append('}');
            }
        }
    }
}

