/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.myfaces.shared.util.StringUtils;

public class ResourceLoaderUtils {
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String[] HTTP_REQUEST_DATE_HEADER = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMMM d HH:mm:ss yyyy"};
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static String formatDateHeader(long value) {
        SimpleDateFormat format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
        format.setTimeZone(GMT);
        return format.format(new Date(value));
    }

    public static Long parseDateHeader(String value) {
        Date date = null;
        for (int i = 0; date == null && i < HTTP_REQUEST_DATE_HEADER.length; ++i) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(HTTP_REQUEST_DATE_HEADER[i], Locale.US);
                format.setTimeZone(GMT);
                date = format.parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getResourceLastModified(URL url) throws IOException {
        long lastModified;
        InputStream is = null;
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                is = jarFileConnection.getInputStream();
                lastModified = jarFileConnection.getLastModified();
            } else {
                is = connection.getInputStream();
                lastModified = connection.getLastModified();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return lastModified;
    }

    public static int getDepth(String path) {
        int depth = 0;
        String[] paths = StringUtils.splitShortString(path, '/');
        if (paths == null) {
            return 0;
        }
        for (String p : paths) {
            if (p == null || p.length() <= 0) continue;
            ++depth;
        }
        return depth;
    }

    public static boolean isDirectory(String path) {
        return path.startsWith("/") && path.endsWith("/");
    }
}

