/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl.digester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.impl.digester.elements.Application;
import org.apache.myfaces.config.impl.digester.elements.Converter;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.Factory;
import org.apache.myfaces.config.impl.digester.elements.LocaleConfig;
import org.apache.myfaces.config.impl.digester.elements.RenderKit;

public class DigesterFacesConfigDispenserImpl
implements FacesConfigDispenser {
    private List configs = new ArrayList();
    private List applicationFactories = new ArrayList();
    private List facesContextFactories = new ArrayList();
    private List lifecycleFactories = new ArrayList();
    private List renderKitFactories = new ArrayList();
    private Map components = new HashMap();
    private Map validators = new HashMap();
    private String defaultRenderKitId;
    private LocaleConfig localeConfig;
    private List actionListeners = new ArrayList();
    private List lifecyclePhaseListeners = new ArrayList();
    private String messageBundle;
    private List navigationHandlers = new ArrayList();
    private List viewHandlers = new ArrayList();
    private List stateManagers = new ArrayList();
    private List propertyResolver = new ArrayList();
    private List variableResolver = new ArrayList();
    private Map converterById = new HashMap();
    private Map converterByClass = new HashMap();
    private Map converterConfigurationByClassName = new HashMap();
    private Map renderKits = new LinkedHashMap();
    private List managedBeans = new ArrayList();
    private List navigationRules = new ArrayList();

    public void feed(Object facesConfig) {
        FacesConfig config = (FacesConfig)facesConfig;
        this.configs.add(config);
        Iterator iterator = config.getFactories().iterator();
        while (iterator.hasNext()) {
            Factory factory = (Factory)iterator.next();
            this.applicationFactories.addAll(factory.getApplicationFactory());
            this.facesContextFactories.addAll(factory.getFacesContextFactory());
            this.lifecycleFactories.addAll(factory.getLifecycleFactory());
            this.renderKitFactories.addAll(factory.getRenderkitFactory());
        }
        this.components.putAll(config.getComponents());
        this.validators.putAll(config.getValidators());
        iterator = config.getApplications().iterator();
        while (iterator.hasNext()) {
            Application application = (Application)iterator.next();
            if (!application.getDefaultRenderkitId().isEmpty()) {
                this.defaultRenderKitId = (String)application.getDefaultRenderkitId().get(application.getDefaultRenderkitId().size() - 1);
            }
            if (!application.getMessageBundle().isEmpty()) {
                this.messageBundle = (String)application.getMessageBundle().get(application.getMessageBundle().size() - 1);
            }
            if (!application.getLocaleConfig().isEmpty()) {
                this.localeConfig = (LocaleConfig)application.getLocaleConfig().get(application.getLocaleConfig().size() - 1);
            }
            this.actionListeners.addAll(application.getActionListener());
            this.navigationHandlers.addAll(application.getNavigationHandler());
            this.viewHandlers.addAll(application.getViewHandler());
            this.stateManagers.addAll(application.getStateManager());
            this.propertyResolver.addAll(application.getPropertyResolver());
            this.variableResolver.addAll(application.getVariableResolver());
        }
        iterator = config.getConverters().iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (converter.getConverterId() != null) {
                this.converterById.put(converter.getConverterId(), converter.getConverterClass());
            } else {
                this.converterByClass.put(converter.getForClass(), converter.getConverterClass());
            }
            this.converterConfigurationByClassName.put(converter.getConverterClass(), converter);
        }
        iterator = config.getRenderKits().iterator();
        while (iterator.hasNext()) {
            RenderKit existing;
            RenderKit renderKit = (RenderKit)iterator.next();
            String renderKitId = renderKit.getId();
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if ((existing = (RenderKit)this.renderKits.get(renderKitId)) == null) {
                this.renderKits.put(renderKit.getId(), renderKit);
                continue;
            }
            existing.merge(renderKit);
        }
        this.lifecyclePhaseListeners.addAll(config.getLifecyclePhaseListener());
        this.managedBeans.addAll(config.getManagedBeans());
        this.navigationRules.addAll(config.getNavigationRules());
    }

    public void feedApplicationFactory(String factoryClassName) {
        this.applicationFactories.add(factoryClassName);
    }

    public void feedFacesContextFactory(String factoryClassName) {
        this.facesContextFactories.add(factoryClassName);
    }

    public void feedLifecycleFactory(String factoryClassName) {
        this.lifecycleFactories.add(factoryClassName);
    }

    public void feedRenderKitFactory(String factoryClassName) {
        this.renderKitFactories.add(factoryClassName);
    }

    public Iterator getApplicationFactoryIterator() {
        return this.applicationFactories.iterator();
    }

    public Iterator getFacesContextFactoryIterator() {
        return this.facesContextFactories.iterator();
    }

    public Iterator getLifecycleFactoryIterator() {
        return this.lifecycleFactories.iterator();
    }

    public Iterator getRenderKitFactoryIterator() {
        return this.renderKitFactories.iterator();
    }

    public Iterator getActionListenerIterator() {
        ArrayList listeners = new ArrayList(this.actionListeners);
        return listeners.iterator();
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public Iterator getNavigationHandlerIterator() {
        ArrayList handlers = new ArrayList(this.navigationHandlers);
        return handlers.iterator();
    }

    public Iterator getViewHandlerIterator() {
        ArrayList handlers = new ArrayList(this.viewHandlers);
        return handlers.iterator();
    }

    public Iterator getStateManagerIterator() {
        ArrayList managers = new ArrayList(this.stateManagers);
        return managers.iterator();
    }

    public Iterator getPropertyResolverIterator() {
        ArrayList resolver = new ArrayList(this.propertyResolver);
        return resolver.iterator();
    }

    public Iterator getVariableResolverIterator() {
        ArrayList resolver = new ArrayList(this.variableResolver);
        return resolver.iterator();
    }

    public String getDefaultLocale() {
        if (this.localeConfig != null) {
            return this.localeConfig.getDefaultLocale();
        }
        return null;
    }

    public Iterator getSupportedLocalesIterator() {
        if (this.localeConfig != null) {
            return this.localeConfig.getSupportedLocales().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getComponentTypes() {
        return this.components.keySet().iterator();
    }

    public String getComponentClass(String componentType) {
        return (String)this.components.get(componentType);
    }

    public Iterator getConverterIds() {
        return this.converterById.keySet().iterator();
    }

    public Iterator getConverterClasses() {
        return this.converterByClass.keySet().iterator();
    }

    public Iterator getConverterConfigurationByClassName() {
        return this.converterConfigurationByClassName.keySet().iterator();
    }

    public Converter getConverterConfiguration(String converterClassName) {
        return (Converter)this.converterConfigurationByClassName.get(converterClassName);
    }

    public String getConverterClassById(String converterId) {
        return (String)this.converterById.get(converterId);
    }

    public String getConverterClassByClass(String className) {
        return (String)this.converterByClass.get(className);
    }

    public Iterator getValidatorIds() {
        return this.validators.keySet().iterator();
    }

    public String getValidatorClass(String validatorId) {
        return (String)this.validators.get(validatorId);
    }

    public Iterator getManagedBeans() {
        return this.managedBeans.iterator();
    }

    public Iterator getNavigationRules() {
        return this.navigationRules.iterator();
    }

    public Iterator getRenderKitIds() {
        return this.renderKits.keySet().iterator();
    }

    public String getRenderKitClass(String renderKitId) {
        RenderKit renderKit = (RenderKit)this.renderKits.get(renderKitId);
        return renderKit.getRenderKitClass();
    }

    public Iterator getRenderers(String renderKitId) {
        RenderKit renderKit = (RenderKit)this.renderKits.get(renderKitId);
        return renderKit.getRenderer().iterator();
    }

    public Iterator getLifecyclePhaseListeners() {
        return this.lifecyclePhaseListeners.iterator();
    }
}

