/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.impl.digester.elements.Converter;

public class RuntimeConfig {
    private static final Log log = LogFactory.getLog((Class)RuntimeConfig.class);
    private static final String APPLICATION_MAP_PARAM_NAME = RuntimeConfig.class.getName();
    private Collection _navigationRules = new ArrayList();
    private Map _managedBeans = new HashMap();
    private Map _oldManagedBeans = new HashMap();
    private Map _managedBeansPerLocation = new HashMap();
    private boolean _navigationRulesChanged = false;
    private Map _converterClassNameToConfigurationMap = Collections.synchronizedMap(new HashMap());

    public static RuntimeConfig getCurrentInstance(ExternalContext externalContext) {
        RuntimeConfig runtimeConfig = (RuntimeConfig)externalContext.getApplicationMap().get(APPLICATION_MAP_PARAM_NAME);
        if (runtimeConfig == null) {
            runtimeConfig = new RuntimeConfig();
            externalContext.getApplicationMap().put(APPLICATION_MAP_PARAM_NAME, runtimeConfig);
        }
        return runtimeConfig;
    }

    public void purge() {
        this._navigationRules = new ArrayList();
        this._oldManagedBeans = this._managedBeans;
        this._managedBeans = new HashMap();
        this._managedBeansPerLocation = new HashMap();
        this._navigationRulesChanged = false;
        this._converterClassNameToConfigurationMap = Collections.synchronizedMap(new HashMap());
    }

    public Collection getNavigationRules() {
        return this._navigationRules == null ? null : Collections.unmodifiableCollection(this._navigationRules);
    }

    public Map getManagedBeans() {
        return this._managedBeans == null ? null : Collections.unmodifiableMap(this._managedBeans);
    }

    public void addNavigationRule(NavigationRule navigationRule) {
        this._navigationRules.add(navigationRule);
        this._navigationRulesChanged = true;
    }

    public boolean isNavigationRulesChanged() {
        return this._navigationRulesChanged;
    }

    public void setNavigationRulesChanged(boolean navigationRulesChanged) {
        this._navigationRulesChanged = navigationRulesChanged;
    }

    public ManagedBean getManagedBean(String name) {
        return (ManagedBean)this._managedBeans.get(name);
    }

    public List getManagedBeans(String name) {
        List li = (List)this._managedBeansPerLocation.get(name);
        return li == null ? null : Collections.unmodifiableList(li);
    }

    public void addManagedBean(String name, ManagedBean managedBean) {
        ArrayList<ManagedBean> li;
        this._managedBeans.put(name, managedBean);
        if (this._oldManagedBeans != null) {
            this._oldManagedBeans.remove(name);
        }
        if ((li = (ArrayList<ManagedBean>)this._managedBeansPerLocation.get(name)) == null) {
            li = new ArrayList<ManagedBean>();
            this._managedBeansPerLocation.put(name, li);
        }
        li.add(managedBean);
    }

    public Map getManagedBeansNotReaddedAfterPurge() {
        return this._oldManagedBeans;
    }

    public void resetManagedBeansNotReaddedAfterPurge() {
        this._oldManagedBeans = null;
    }

    public void addConverterConfiguration(String converterClassName, Converter configuration) {
        if (converterClassName == null || converterClassName.length() == 0) {
            log.error((Object)"addConverterConfiguration: converterClassName = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: converterClassName = null is not allowed");
        }
        if (configuration == null) {
            log.error((Object)"addConverterConfiguration: configuration = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: configuration = null is not allowed");
        }
        this._converterClassNameToConfigurationMap.put(converterClassName, configuration);
    }

    public Converter getConverterConfiguration(String converterClassName) {
        return (Converter)this._converterClassNameToConfigurationMap.get(converterClassName);
    }
}

