/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class ActionListenerImpl
implements ActionListener {
    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        String outcome;
        String fromAction;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        ActionSource actionSource = (ActionSource)actionEvent.getComponent();
        MethodBinding methodBinding = actionSource.getAction();
        if (methodBinding == null) {
            fromAction = null;
            outcome = null;
        } else {
            fromAction = methodBinding.getExpressionString();
            try {
                outcome = (String)methodBinding.invoke(facesContext, null);
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw new FacesException("Error calling action method of component with id " + actionEvent.getComponent().getClientId(facesContext), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new FacesException("Error calling action method of component with id " + actionEvent.getComponent().getClientId(facesContext), (Throwable)e);
            }
        }
        NavigationHandler navigationHandler = application.getNavigationHandler();
        navigationHandler.handleNavigation(facesContext, fromAction, outcome);
        facesContext.renderResponse();
    }
}

