/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    private static final String CONVERSION_MESSAGE_ID = "javax.faces.convert.DateTimeConverter.CONVERSION";
    private static final TimeZone TIMEZONE_DEFAULT = TimeZone.getTimeZone("GMT");
    private String _dateStyle;
    private Locale _locale;
    private String _pattern;
    private String _timeStyle;
    private TimeZone _timeZone;
    private String _type;
    private boolean _transient;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (context == null) {
            throw new NullPointerException("facesContext");
        }
        if (component == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.length() == 0) {
            return null;
        }
        try {
            return this.prepareDateFormat().parse(trimmedValue);
        }
        catch (Exception e) {
            throw new ConverterException(_MessageUtils.getErrorMessage(context, CONVERSION_MESSAGE_ID, new Object[]{value, component.getId()}), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (context == null) {
            throw new NullPointerException("facesContext");
        }
        if (component == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return this.prepareDateFormat().format(value);
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private DateFormat prepareDateFormat() {
        DateFormat format = this.getDateFormat();
        format.setLenient(false);
        TimeZone tz = this.getTimeZone();
        if (tz != null) {
            format.setTimeZone(tz);
        }
        return format;
    }

    private DateFormat getDateFormat() {
        if (this._pattern != null) {
            try {
                return new SimpleDateFormat(this._pattern, this.getLocale());
            }
            catch (IllegalArgumentException iae) {
                throw new ConverterException("Invalid pattern", (Throwable)iae);
            }
        }
        return Type.getType(this.getType()).getFormatter(this.calcDateStyle(), this.calcTimeStyle(), this.getLocale());
    }

    private int calcDateStyle() {
        return Style.getStyleFormat(this.getDateStyle());
    }

    private int calcTimeStyle() {
        return Style.getStyleFormat(this.getTimeStyle());
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._dateStyle = (String)values[0];
        this._locale = (Locale)values[1];
        this._pattern = (String)values[2];
        this._timeStyle = (String)values[3];
        this._timeZone = (TimeZone)values[4];
        this._type = (String)values[5];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._dateStyle, this._locale, this._pattern, this._timeStyle, this._timeZone, this._type};
        return values;
    }

    public String getDateStyle() {
        return this._dateStyle != null ? this._dateStyle : Style.DEFAULT.getName();
    }

    public void setDateStyle(String dateStyle) {
        this._dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public String getTimeStyle() {
        return this._timeStyle != null ? this._timeStyle : Style.DEFAULT.getName();
    }

    public void setTimeStyle(String timeStyle) {
        this._timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this._timeZone != null ? this._timeZone : TIMEZONE_DEFAULT;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public String getType() {
        return this._type != null ? this._type : Type.DATE.getName();
    }

    public void setType(String type) {
        this._type = type;
    }

    private static abstract class Type {
        private static final Type DATE = new Type("date"){

            public DateFormat getFormatter(int dateStyle, int timeStyle, Locale locale) {
                return DateFormat.getDateInstance(dateStyle, locale);
            }
        };
        private static final Type TIME = new Type("time"){

            public DateFormat getFormatter(int dateStyle, int timeStyle, Locale locale) {
                return DateFormat.getTimeInstance(timeStyle, locale);
            }
        };
        private static final Type BOTH = new Type("both"){

            public DateFormat getFormatter(int dateStyle, int timeStyle, Locale locale) {
                return DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
            }
        };
        private static final Type[] values = new Type[]{DATE, TIME, BOTH};
        private String _name;

        public static Type getType(String name) {
            for (int i = 0; i < values.length; ++i) {
                if (!Type.values[i]._name.equals(name)) continue;
                return values[i];
            }
            throw new ConverterException("invalid type '" + name + "'");
        }

        private Type(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public abstract DateFormat getFormatter(int var1, int var2, Locale var3);
    }

    private static class Style {
        private static final Style DEFAULT = new Style("default", 2);
        private static final Style MEDIUM = new Style("medium", 2);
        private static final Style SHORT = new Style("short", 3);
        private static final Style LONG = new Style("long", 1);
        private static final Style FULL = new Style("full", 0);
        private static final Style[] values = new Style[]{DEFAULT, MEDIUM, SHORT, LONG, FULL};
        private String _name;
        private int _format;

        public static Style getStyle(String name) {
            for (int i = 0; i < values.length; ++i) {
                if (!Style.values[i]._name.equals(name)) continue;
                return values[i];
            }
            throw new ConverterException("invalid style '" + name + "'");
        }

        private static int getStyleFormat(String name) {
            return Style.getStyle(name).getFormat();
        }

        private Style(String name, int format) {
            this._name = name;
            this._format = format;
        }

        public String getName() {
            return this._name;
        }

        public int getFormat() {
            return this._format;
        }
    }
}

