/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.jce;

import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.EdECKey;
import java.security.spec.NamedParameterSpec;
import org.apache.sshd.common.util.security.PublicKeyFactory;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSAUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcePublicKeyFactory
implements PublicKeyFactory {
    @Override
    public PublicKey getPublicKey(PrivateKey key) {
        if ("EdDSA".equalsIgnoreCase(key.getAlgorithm()) && key instanceof EdECKey && key.getClass().getCanonicalName().startsWith("sun.")) {
            NamedParameterSpec params = ((EdECKey)((Object)key)).getParams();
            return JcePublicKeyFactory.recoverEd25519PublicKey(key, params);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey recoverEd25519PublicKey(PrivateKey key, NamedParameterSpec params) {
        final byte[] rawPrivateKey = EdDSAUtils.getBytes(key);
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance(params.getName(), "SunEC");
            gen.initialize(params, new SecureRandom(){
                private static final long serialVersionUID = 1L;

                @Override
                public void nextBytes(byte[] bytes) {
                    if (bytes.length != rawPrivateKey.length) {
                        throw new IllegalStateException("Wrong array length requested; expected " + rawPrivateKey.length + " but got " + bytes.length);
                    }
                    System.arraycopy(rawPrivateKey, 0, bytes, 0, rawPrivateKey.length);
                }
            });
            PublicKey publicKey = gen.generateKeyPair().getPublic();
            return publicKey;
        }
        catch (GeneralSecurityException e) {
            PublicKey publicKey = null;
            return publicKey;
        }
        finally {
            Arrays.fill((byte[])rawPrivateKey, (byte)0);
        }
    }
}

