package org.apache.maven.plugin.coreit;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;

import java.io.File;

/**
 * @author <a href="brett@apache.org">Brett Porter</a>
 * @version $Id: PackagingMojo.java 368108 2006-01-11 19:36:37Z jvanzyl $
 * @goal package
 */
public class PackagingMojo
    extends AbstractMojo
{
    
    /**
     * @parameter expression="${project}"
     * @required
     */
    private MavenProject project;

    /**
     * @parameter expression="${project.build.finalName}"
     * @required
     */
    private String finalName;

    /**
     * @parameter expression="${project.build.directory}"
     * @required
     * @readonly
     */
    private String outputDirectory;

    public void execute()
        throws MojoExecutionException
    {
        File jarFile = new File( outputDirectory, finalName + "-it.jar" );

        MavenArchiver archiver = new MavenArchiver();

        archiver.setArchiver( new JarArchiver() );

        archiver.setOutputFile( jarFile );

        try
        {
            archiver.createArchive( project, new MavenArchiveConfiguration() );
        }
        catch ( Exception e )
        {
            // TODO: improve error handling
            throw new MojoExecutionException( "Error assembling JAR", e );
        }
        
        project.getArtifact().setFile( jarFile );
    }

}
                    
