/**

  All content copyright (c) 2003-2007 Terracotta, Inc.,
  except as may otherwise be noted in a separate copyright notice.
  All rights reserved.

*/
package ${packageName}.demo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class View extends JFrame implements ActionListener, Observer {
   
   private Model model;
   private JButton button;
   
   public View() {
      model = new Model();
      model.setObserver(this);
      setDefaultLookAndFeelDecorated(true);
      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      Container content = getContentPane();
      button = new JButton();
      button.setFont(new Font("sanserif", Font.PLAIN, 75));
      button.addActionListener(this);
      content.setLayout(new BorderLayout());
      content.add(button, BorderLayout.CENTER);
      pack();
      setTitle("App");
      setSize(new Dimension(600, 300));
   }
   
   public void display() {
      setVisible(true);
      displayCount(button);
   }
   
   public void actionPerformed(final ActionEvent e) {
      model.modify();
   }

   public void update(Observable o, Object arg) {
      displayCount(button);
   }
   
   private void displayCount(final JButton button) {
      SwingUtilities.invokeLater(new Runnable() {
        public void run() { button.setText(model.toString()); }
      });
   }
   
}