/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.mojo.mgmt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 80;
    private static final String DEFAULT_INDENT = HelpMojo.repeat(" ", 2);
    private boolean detail;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("The 'cisco.infra.dft:maven-dma-mgmt-plugin' plugin has 4 goals:").append("\n");
        sb.append("\n");
        sb.append("dma-mgmt:help").append("\n");
        Iterator it = HelpMojo.toLines("Display help information on 'cisco.infra.dft:maven-dma-mgmt-plugin' plugin. Call 'mvn dma-mgmt:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("detail (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("If true, display all settable properies for each goal.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("dma-mgmt:validateRepo").append("\n");
        it = HelpMojo.toLines("This goal will scour the trunk directories DMA SVN repository looking for java projects that use Maven. When a Maven POM file is found, its ancestor POMs will be downloaded and finally a health report will be created. dma.pom.enforcer rules are applied to the ensure that the POM is sound.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        sb.append("\n");
        sb.append("dma-mgmt:updateAuthz").append("\n");
        it = HelpMojo.toLines("No description available.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("authzFile", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("No description available.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("pomDir", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("No description available.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("dma-mgmt:help").append("\n");
        it = HelpMojo.toLines("Display help information on 'cisco.infra.dft:maven-dma-mgmt-plugin' plugin. Call 'mvn dma-mgmt:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static List toLines(String str) {
        return HelpMojo.toLines(str, DEFAULT_INDENT, 80);
    }

    private static List toLines(String str, String indent, int size) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (indent == null) {
            indent = "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("size should be positive");
        }
        StringBuffer tmp = new StringBuffer(indent);
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (tmp.length() + word.length() + 1 < size) {
                tmp.append(word).append(" ");
                continue;
            }
            sentences.add(tmp.toString());
            tmp = new StringBuffer(indent);
            tmp.append(word).append(" ");
        }
        if (tmp.toString().length() > 0) {
            sentences.add(tmp.toString());
        }
        return sentences;
    }
}

