/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.container.ReferenceRecipe;
import org.apache.aries.blueprint.container.Voidable;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.proxy.CollaboratorFactory;
import org.apache.aries.blueprint.proxy.ProxyUtils;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.blueprint.utils.generics.OwbParametrizedTypeImpl;
import org.apache.aries.blueprint.utils.generics.TypeInference;
import org.apache.aries.proxy.UnableToProxyException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRecipe
extends AbstractRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanRecipe.class);
    private final ExtendedBlueprintContainer blueprintContainer;
    private final LinkedHashMap<String, Object> properties = new LinkedHashMap();
    private final Object type;
    private String initMethod;
    private String destroyMethod;
    private List<Recipe> explicitDependencies;
    private Recipe factory;
    private String factoryMethod;
    private List<Object> arguments;
    private List<String> argTypes;
    private boolean reorderArguments;
    private final boolean allowFieldInjection;
    private final boolean allowRawConversion;
    private final boolean allowNonStandardSetters;
    private BeanMetadata interceptorLookupKey;
    private static Object UNMATCHED = new Object();

    public BeanRecipe(String name, ExtendedBlueprintContainer blueprintContainer, Object type, boolean allowFieldInjection, boolean allowRawConversion, boolean allowNonStandardSetters) {
        super(name);
        this.blueprintContainer = blueprintContainer;
        this.type = type;
        this.allowFieldInjection = allowFieldInjection;
        this.allowRawConversion = allowRawConversion;
        this.allowNonStandardSetters = allowNonStandardSetters;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return new LinkedHashMap<String, Object>(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setFactoryMethod(String method) {
        this.factoryMethod = method;
    }

    public void setFactoryComponent(Recipe factory) {
        this.factory = factory;
    }

    public void setArgTypes(List<String> argTypes) {
        this.argTypes = argTypes;
    }

    public void setArguments(List<Object> arguments) {
        this.arguments = arguments;
    }

    public void setReorderArguments(boolean reorder) {
        this.reorderArguments = reorder;
    }

    public void setInitMethod(String initMethod) {
        this.initMethod = initMethod;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public List<Recipe> getExplicitDependencies() {
        return this.explicitDependencies;
    }

    public void setExplicitDependencies(List<Recipe> explicitDependencies) {
        this.explicitDependencies = explicitDependencies;
    }

    public void setInterceptorLookupKey(BeanMetadata metadata) {
        this.interceptorLookupKey = metadata;
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.explicitDependencies != null) {
            recipes.addAll(this.explicitDependencies);
        }
        if (this.arguments != null) {
            for (Object argument : this.arguments) {
                if (!(argument instanceof Recipe)) continue;
                recipes.add((Recipe)argument);
            }
        }
        return recipes;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Object o : this.properties.values()) {
            if (!(o instanceof Recipe)) continue;
            Recipe recipe = (Recipe)o;
            recipes.add(recipe);
        }
        if (this.factory != null) {
            recipes.add(this.factory);
        }
        recipes.addAll(this.getConstructorDependencies());
        return recipes;
    }

    private void instantiateExplicitDependencies() {
        if (this.explicitDependencies != null) {
            for (Recipe recipe : this.explicitDependencies) {
                recipe.create();
            }
        }
    }

    @Override
    protected Class loadClass(String className) {
        ClassLoader loader = this.type instanceof Class ? ((Class)this.type).getClassLoader() : null;
        ReifiedType t = this.loadType(className, loader);
        return t != null ? t.getRawClass() : null;
    }

    @Override
    protected ReifiedType loadType(String className) {
        return this.loadType(className, this.type instanceof Class ? ((Class)this.type).getClassLoader() : null);
    }

    private Object getInstance() throws ComponentDefinitionException {
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<ReifiedType> argTypes = new ArrayList<ReifiedType>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Object arg = this.arguments.get(i);
                if (arg instanceof Recipe) {
                    args.add(((Recipe)arg).create());
                } else {
                    args.add(arg);
                }
                if (this.argTypes == null) continue;
                argTypes.add(this.argTypes.get(i) != null ? this.loadType(this.argTypes.get(i)) : null);
            }
        }
        if (this.factory != null) {
            return this.getInstanceFromFactory(args, argTypes);
        }
        if (this.factoryMethod != null) {
            return this.getInstanceFromStaticFactory(args, argTypes);
        }
        return this.getInstanceFromType(args, argTypes);
    }

    private Object getInstanceFromFactory(List<Object> args, List<ReifiedType> argTypes) {
        Object factoryObj = this.getFactoryObj();
        Map<Method, List<Object>> matches = this.findMatchingMethods(factoryObj.getClass(), this.factoryMethod, true, args, argTypes);
        if (matches.size() == 1) {
            try {
                Map.Entry<Method, List<Object>> match = matches.entrySet().iterator().next();
                return this.invoke(match.getKey(), factoryObj, match.getValue().toArray());
            }
            catch (Throwable e) {
                throw this.wrapAsCompDefEx(e);
            }
        }
        if (matches.size() == 0) {
            throw new ComponentDefinitionException("Unable to find a matching factory method " + this.factoryMethod + " on class " + factoryObj.getClass().getName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName());
        }
        throw new ComponentDefinitionException("Multiple matching factory methods " + this.factoryMethod + " found on class " + factoryObj.getClass().getName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName() + ": " + matches.keySet());
    }

    private Object getFactoryObj() {
        Object factoryObj = this.factory.create();
        if (factoryObj instanceof ReferenceRecipe.ServiceProxyWrapper) {
            try {
                factoryObj = ((ReferenceRecipe.ServiceProxyWrapper)factoryObj).convert(new ReifiedType(Object.class));
            }
            catch (Exception e) {
                throw this.wrapAsCompDefEx(e);
            }
        } else if (factoryObj instanceof UnwrapperedBeanHolder) {
            factoryObj = BeanRecipe.wrap((UnwrapperedBeanHolder)factoryObj, Object.class);
        }
        return factoryObj;
    }

    private Object getInstanceFromStaticFactory(List<Object> args, List<ReifiedType> argTypes) {
        Map<Method, List<Object>> matches = this.findMatchingMethods(this.getType(), this.factoryMethod, false, args, argTypes);
        if (matches.size() == 1) {
            try {
                Map.Entry<Method, List<Object>> match = matches.entrySet().iterator().next();
                return this.invoke(match.getKey(), null, match.getValue().toArray());
            }
            catch (Throwable e) {
                throw this.wrapAsCompDefEx(e);
            }
        }
        if (matches.size() == 0) {
            throw new ComponentDefinitionException("Unable to find a matching factory method " + this.factoryMethod + " on class " + this.getTypeName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName());
        }
        throw new ComponentDefinitionException("Multiple matching factory methods " + this.factoryMethod + " found on class " + this.getTypeName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName() + ": " + matches.keySet());
    }

    private Object getInstanceFromType(List<Object> args, List<ReifiedType> argTypes) {
        if (this.getType() == null) {
            throw new ComponentDefinitionException("No factoryMethod nor class is defined for this bean");
        }
        Map<Constructor<?>, List<Object>> matches = this.findMatchingConstructors(this.getType(), args, argTypes);
        if (matches.size() == 1) {
            try {
                Map.Entry<Constructor<?>, List<Object>> match = matches.entrySet().iterator().next();
                return this.newInstance(match.getKey(), match.getValue().toArray());
            }
            catch (Throwable e) {
                throw this.wrapAsCompDefEx(e);
            }
        }
        if (matches.size() == 0) {
            throw new ComponentDefinitionException("Unable to find a matching constructor on class " + this.getTypeName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName());
        }
        throw new ComponentDefinitionException("Multiple matching constructors found on class " + this.getTypeName() + " for arguments " + this.argsToString(args) + " when instanciating bean " + this.getName() + ": " + matches.keySet());
    }

    private ComponentDefinitionException wrapAsCompDefEx(Throwable e) {
        return new ComponentDefinitionException("Error when instantiating bean " + this.getName() + " of class " + this.getTypeName(), ReflectionUtils.getRealCause(e));
    }

    private String getTypeName() {
        Class type = this.getType();
        return type == null ? null : type.getName();
    }

    private Map<Constructor<?>, List<Object>> findMatchingConstructors(Class type, List<Object> args, List<ReifiedType> types) {
        TIConverter cnv;
        List<TypeInference.TypedObject> targs = this.getTypedObjects(args, types);
        List<TypeInference.Match<Constructor<?>>> m = TypeInference.findMatchingConstructors(type, targs, cnv = new TIConverter(), this.reorderArguments);
        if (!m.isEmpty()) {
            int score = m.iterator().next().getScore();
            Iterator<TypeInference.Match<Constructor<?>>> each = m.iterator();
            while (each.hasNext()) {
                if (each.next().getScore() <= score) continue;
                each.remove();
            }
        }
        HashMap map = new HashMap();
        for (TypeInference.Match<Constructor<?>> match : m) {
            ArrayList<Object> nargs = new ArrayList<Object>();
            for (TypeInference.TypedObject to : match.getArgs()) {
                nargs.add(to.getValue());
            }
            map.put(match.getMember(), nargs);
        }
        return map;
    }

    private Map<Method, List<Object>> findMatchingMethods(Class type, String name, boolean instance, List<Object> args, List<ReifiedType> types) {
        List<TypeInference.TypedObject> targs = this.getTypedObjects(args, types);
        TIConverter cnv = new TIConverter();
        List<TypeInference.Match<Method>> m = instance ? TypeInference.findMatchingMethods(type, name, targs, cnv, this.reorderArguments) : TypeInference.findMatchingStatics(type, name, targs, cnv, this.reorderArguments);
        if (!m.isEmpty()) {
            int score = m.iterator().next().getScore();
            Iterator<TypeInference.Match<Method>> each = m.iterator();
            while (each.hasNext()) {
                if (each.next().getScore() <= score) continue;
                each.remove();
            }
        }
        HashMap<Method, List<Object>> map = new HashMap<Method, List<Object>>();
        for (TypeInference.Match<Method> match : m) {
            ArrayList<Object> nargs = new ArrayList<Object>();
            for (TypeInference.TypedObject to : match.getArgs()) {
                nargs.add(to.getValue());
            }
            map.put(match.getMember(), nargs);
        }
        return map;
    }

    protected Object convert(Object obj, Type from, Type to) throws Exception {
        if (this.allowRawConversion && (from instanceof ParameterizedType || to instanceof ParameterizedType) && GenericType.getConcreteClass(from) == GenericType.getConcreteClass(to)) {
            boolean assignable = true;
            if (from instanceof ParameterizedType) {
                for (Type t : ((ParameterizedType)from).getActualTypeArguments()) {
                    assignable &= t == Object.class;
                }
            }
            if (to instanceof ParameterizedType) {
                for (Type t : ((ParameterizedType)to).getActualTypeArguments()) {
                    assignable &= t == Object.class;
                }
            }
            if (assignable) {
                return obj instanceof UnwrapperedBeanHolder ? ((UnwrapperedBeanHolder)obj).unwrapperedBean : obj;
            }
        }
        return this.convert(obj, to);
    }

    private Type toType(ReifiedType rt) {
        if (rt.size() > 0) {
            Type[] at = new Type[rt.size()];
            for (int j = 0; j < at.length; ++j) {
                at[j] = this.toType(rt.getActualTypeArgument(j));
            }
            return new OwbParametrizedTypeImpl(null, rt.getRawClass(), at);
        }
        return rt.getRawClass();
    }

    private List<TypeInference.TypedObject> getTypedObjects(List<Object> args, List<ReifiedType> types) {
        ArrayList<TypeInference.TypedObject> targs = new ArrayList<TypeInference.TypedObject>();
        for (int i = 0; i < args.size(); ++i) {
            Type t;
            Object o = args.get(i);
            ReifiedType rt = types.get(i);
            if (rt == null && o != null) {
                Object ot = o instanceof UnwrapperedBeanHolder ? ((UnwrapperedBeanHolder)o).unwrapperedBean : o;
                rt = new GenericType(ot.getClass());
            }
            if (rt != null) {
                if (rt.size() == 0 && rt.getRawClass().getTypeParameters().length > 0 && rt.getRawClass() != Class.class) {
                    GenericType[] tt = new GenericType[rt.getRawClass().getTypeParameters().length];
                    Arrays.fill((Object[])tt, 0, tt.length, (Object)new GenericType((Type)((Object)Object.class)));
                    rt = new GenericType(rt.getRawClass(), tt);
                }
                t = this.toType(rt);
            } else {
                t = null;
            }
            targs.add(new TypeInference.TypedObject(t, o));
        }
        return targs;
    }

    protected Method getInitMethod(Object instance) throws ComponentDefinitionException {
        Method method = null;
        if (this.initMethod != null && this.initMethod.length() > 0 && (method = ReflectionUtils.getLifecycleMethod(instance.getClass(), this.initMethod)) == null) {
            throw new ComponentDefinitionException("Component '" + this.getName() + "' does not have init-method: " + this.initMethod);
        }
        return method;
    }

    public Method getDestroyMethod(Object instance) throws ComponentDefinitionException {
        Method method = null;
        if (instance != null && this.destroyMethod != null && this.destroyMethod.length() > 0 && (method = ReflectionUtils.getLifecycleMethod(instance.getClass(), this.destroyMethod)) == null) {
            throw new ComponentDefinitionException("Component '" + this.getName() + "' does not have destroy-method: " + this.destroyMethod);
        }
        return method;
    }

    private Object runBeanProcPreInit(Object obj) {
        BeanProcessor.BeanCreator initialBeanCreator;
        String beanName = this.getName();
        BeanMetadata beanData = (BeanMetadata)this.blueprintContainer.getComponentDefinitionRegistry().getComponentDefinition(beanName);
        List<BeanProcessor> processors = this.blueprintContainer.getProcessors(BeanProcessor.class);
        BeanProcessor.BeanCreator currentCreator = initialBeanCreator = new BeanProcessor.BeanCreator(){

            @Override
            public Object getBean() {
                Object obj = BeanRecipe.this.getInstance();
                BeanRecipe.this.setProperties(obj);
                return obj;
            }
        };
        for (BeanProcessor processor : processors) {
            obj = processor.beforeInit(obj, this.getName(), currentCreator, beanData);
            currentCreator = new BeanCreatorChain(currentCreator, processor, beanData, beanName, BeanCreatorChain.ChainType.Before);
        }
        return obj;
    }

    private void runBeanProcInit(Method initMethod, Object obj) {
        if (initMethod != null) {
            try {
                this.invoke(initMethod, obj, null);
            }
            catch (Throwable t) {
                throw new ComponentDefinitionException("Unable to initialize bean " + this.getName(), ReflectionUtils.getRealCause(t));
            }
        }
    }

    private Object runBeanProcPostInit(Object obj) {
        BeanProcessor.BeanCreator initialBeanCreator;
        String beanName = this.getName();
        BeanMetadata beanData = (BeanMetadata)this.blueprintContainer.getComponentDefinitionRegistry().getComponentDefinition(beanName);
        List<BeanProcessor> processors = this.blueprintContainer.getProcessors(BeanProcessor.class);
        BeanProcessor.BeanCreator currentCreator = initialBeanCreator = new BeanProcessor.BeanCreator(){

            @Override
            public Object getBean() {
                Object obj = BeanRecipe.this.getInstance();
                BeanRecipe.this.setProperties(obj);
                obj = BeanRecipe.this.runBeanProcPreInit(obj);
                BeanRecipe.this.runBeanProcInit(BeanRecipe.this.getInitMethod(obj), obj);
                return obj;
            }
        };
        for (BeanProcessor processor : processors) {
            obj = processor.afterInit(obj, this.getName(), currentCreator, beanData);
            currentCreator = new BeanCreatorChain(currentCreator, processor, beanData, beanName, BeanCreatorChain.ChainType.After);
        }
        return obj;
    }

    private Object addInterceptors(Object original, Collection<Class<?>> requiredInterfaces) throws ComponentDefinitionException {
        ComponentDefinitionRegistry reg;
        List<Interceptor> interceptors;
        Object intercepted = null;
        if (requiredInterfaces.isEmpty()) {
            requiredInterfaces.add(original.getClass());
        }
        if ((interceptors = (reg = this.blueprintContainer.getComponentDefinitionRegistry()).getInterceptors((ComponentMetadata)this.interceptorLookupKey)) != null && interceptors.size() > 0) {
            try {
                Bundle b = FrameworkUtil.getBundle(original.getClass());
                if (b == null) {
                    b = this.blueprintContainer.getBundleContext().getBundle();
                }
                intercepted = this.blueprintContainer.getProxyManager().createInterceptingProxy(b, requiredInterfaces, original, CollaboratorFactory.create((ComponentMetadata)this.interceptorLookupKey, interceptors));
            }
            catch (UnableToProxyException e) {
                Bundle b = this.blueprintContainer.getBundleContext().getBundle();
                throw new ComponentDefinitionException("Unable to create proxy for bean " + this.name + " in bundle " + b.getSymbolicName() + "/" + b.getVersion(), (Throwable)e);
            }
        } else {
            intercepted = original;
        }
        return intercepted;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        ReferenceRecipe rr;
        if (this.factory instanceof ReferenceRecipe && (rr = (ReferenceRecipe)this.factory).getProxyChildBeanClasses() != null) {
            return this.createProxyBean(rr);
        }
        return new UnwrapperedBeanHolder(this.internalCreate2(), this);
    }

    private Object createProxyBean(ReferenceRecipe rr) {
        try {
            VoidableCallable vc = new VoidableCallable();
            rr.addVoidableChild(vc);
            return this.blueprintContainer.getProxyManager().createDelegatingProxy(this.blueprintContainer.getBundleContext().getBundle(), rr.getProxyChildBeanClasses(), (Callable)vc, vc.call());
        }
        catch (UnableToProxyException e) {
            throw new ComponentDefinitionException((Throwable)e);
        }
    }

    private Object internalCreate2() throws ComponentDefinitionException {
        this.instantiateExplicitDependencies();
        Object obj = this.getInstance();
        Method initMethod = this.getInitMethod(obj);
        this.getDestroyMethod(obj);
        this.addPartialObject(obj);
        this.setProperties(obj);
        obj = this.runBeanProcPreInit(obj);
        this.runBeanProcInit(initMethod, obj);
        obj = this.runBeanProcPostInit(obj);
        return obj;
    }

    static Object wrap(UnwrapperedBeanHolder holder, Collection<Class<?>> requiredViews) {
        return holder.recipe.addInterceptors(holder.unwrapperedBean, requiredViews);
    }

    static Object wrap(UnwrapperedBeanHolder holder, Class<?> requiredView) {
        if (requiredView == Object.class) {
            return holder.recipe.addInterceptors(holder.unwrapperedBean, new ArrayList(1));
        }
        return holder.recipe.addInterceptors(holder.unwrapperedBean, ProxyUtils.asList(requiredView));
    }

    @Override
    public void destroy(Object obj) {
        if (!(obj instanceof UnwrapperedBeanHolder)) {
            LOGGER.warn("Object to be destroyed is not an instance of UnwrapperedBeanHolder, type: " + obj);
            return;
        }
        obj = ((UnwrapperedBeanHolder)obj).unwrapperedBean;
        for (BeanProcessor processor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            processor.beforeDestroy(obj, this.getName());
        }
        try {
            Method method = this.getDestroyMethod(obj);
            if (method != null) {
                this.invoke(method, obj, null);
            }
        }
        catch (ComponentDefinitionException e) {
            LOGGER.error(e.getMessage());
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            BundleContext ctx = this.blueprintContainer.getBundleContext();
            Bundle b = ctx.getBundle();
            LOGGER.error("The blueprint bean {} in bundle {}/{} incorrectly threw an exception from its destroy method.", new Object[]{this.getName(), b.getSymbolicName(), b.getVersion(), t});
        }
        catch (Exception e) {
            BundleContext ctx = this.blueprintContainer.getBundleContext();
            Bundle b = ctx.getBundle();
            LOGGER.error("An exception occurred while calling the destroy method of the blueprint bean  in bundle {}/{}.", new Object[]{this.getName(), b.getSymbolicName(), b.getVersion(), ReflectionUtils.getRealCause(e)});
        }
        for (BeanProcessor processor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            processor.afterDestroy(obj, this.getName());
        }
    }

    public void setProperties(Object instance) throws ComponentDefinitionException {
        LinkedHashMap<String, Object> propertyValues = new LinkedHashMap<String, Object>(this.properties);
        this.setProperties(propertyValues, instance, instance.getClass());
    }

    public Class getType() {
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            return this.loadClass((String)this.type);
        }
        return null;
    }

    private void setProperties(Map<String, Object> propertyValues, Object instance, Class clazz) {
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            this.setProperty(instance, clazz, propertyName, propertyValue);
        }
    }

    private void setProperty(Object instance, Class clazz, String propertyName, Object propertyValue) {
        ReflectionUtils.PropertyDescriptor pd;
        String[] names = propertyName.split("\\.");
        for (int i = 0; i < names.length - 1; ++i) {
            ReflectionUtils.PropertyDescriptor pd2 = this.getPropertyDescriptor(clazz, names[i]);
            if (pd2.allowsGet()) {
                try {
                    instance = pd2.get(instance, this.blueprintContainer);
                }
                catch (Exception e) {
                    throw new ComponentDefinitionException("Error getting property: " + names[i] + " on bean " + this.getName() + " when setting property " + propertyName + " on class " + clazz.getName(), ReflectionUtils.getRealCause(e));
                }
                if (instance == null) {
                    throw new ComponentDefinitionException("Error setting compound property " + propertyName + " on bean " + this.getName() + ". Property " + names[i] + " is null");
                }
            } else {
                throw new ComponentDefinitionException("No getter for " + names[i] + " property on bean " + this.getName() + " when setting property " + propertyName + " on class " + clazz.getName());
            }
            clazz = instance.getClass();
        }
        if (propertyValue instanceof Recipe) {
            propertyValue = ((Recipe)propertyValue).create();
        }
        if ((pd = this.getPropertyDescriptor(clazz, names[names.length - 1])).allowsSet()) {
            try {
                pd.set(instance, propertyValue, this.blueprintContainer);
            }
            catch (Exception e) {
                throw new ComponentDefinitionException("Error setting property: " + pd, ReflectionUtils.getRealCause(e));
            }
        } else {
            throw new ComponentDefinitionException("No setter for " + names[names.length - 1] + " property");
        }
    }

    private ReflectionUtils.PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) {
        for (ReflectionUtils.PropertyDescriptor pd : ReflectionUtils.getPropertyDescriptors(clazz, this.allowFieldInjection, this.allowNonStandardSetters)) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        throw new ComponentDefinitionException("Unable to find property descriptor " + name + " on class " + clazz.getName());
    }

    private Object invoke(Method method, Object instance, Object ... args) throws Exception {
        return ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, instance, args);
    }

    private Object newInstance(Constructor constructor, Object ... args) throws Exception {
        return ReflectionUtils.newInstance(this.blueprintContainer.getAccessControlContext(), constructor, args);
    }

    private String argsToString(List<Object> args) {
        Iterator<Object> it = args.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            if ((e = it.next()) instanceof UnwrapperedBeanHolder) {
                e = ((UnwrapperedBeanHolder)e).unwrapperedBean;
            }
            sb.append(e).append(" (").append(e.getClass()).append(")");
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private static class TypeEntry {
        private final ReifiedType type;
        private Object argument;

        public TypeEntry(ReifiedType type) {
            this.type = type;
            this.argument = UNMATCHED;
        }
    }

    private class ArgumentMatcher {
        private final List<TypeEntry> entries = new ArrayList<TypeEntry>();
        private final boolean convert;

        public ArgumentMatcher(Type[] types, boolean convert) {
            for (Type type : types) {
                this.entries.add(new TypeEntry(new GenericType(type)));
            }
            this.convert = convert;
        }

        public List<Object> match(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.find(arguments, forcedTypes)) {
                return this.getArguments();
            }
            return null;
        }

        private List<Object> getArguments() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TypeEntry entry : this.entries) {
                if (entry.argument == UNMATCHED) {
                    throw new RuntimeException("There are unmatched generics");
                }
                list.add(entry.argument);
            }
            return list;
        }

        private boolean find(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.entries.size() == arguments.size()) {
                boolean matched = true;
                for (int i = 0; i < arguments.size() && matched; ++i) {
                    matched = this.find(arguments.get(i), forcedTypes.get(i));
                }
                return matched;
            }
            return false;
        }

        private boolean find(Object arg, ReifiedType forcedType) {
            for (TypeEntry entry : this.entries) {
                Object val = arg;
                if (entry.argument != UNMATCHED) continue;
                if (forcedType != null) {
                    if (!forcedType.equals(entry.type)) {
                        continue;
                    }
                } else if (arg != null) {
                    if (this.convert) {
                        if (!BeanRecipe.this.canConvert(arg, entry.type)) continue;
                        try {
                            val = BeanRecipe.this.convert(arg, entry.type);
                        }
                        catch (Exception e) {
                            throw new ComponentDefinitionException((Throwable)e);
                        }
                    } else {
                        UnwrapperedBeanHolder holder = null;
                        if (arg instanceof UnwrapperedBeanHolder) {
                            holder = (UnwrapperedBeanHolder)arg;
                            arg = holder.unwrapperedBean;
                        }
                        if (!AggregateConverter.isAssignable(arg, entry.type)) continue;
                        if (holder != null) {
                            val = BeanRecipe.wrap(holder, entry.type.getRawClass());
                        }
                    }
                }
                entry.argument = val;
                return true;
            }
            return false;
        }
    }

    private static class BeanCreatorChain
    implements BeanProcessor.BeanCreator {
        private final BeanProcessor.BeanCreator parentBeanCreator;
        private final BeanProcessor parentBeanProcessor;
        private final BeanMetadata beanData;
        private final String beanName;
        private final ChainType when;

        public BeanCreatorChain(BeanProcessor.BeanCreator parentBeanCreator, BeanProcessor parentBeanProcessor, BeanMetadata beanData, String beanName, ChainType when) {
            this.parentBeanCreator = parentBeanCreator;
            this.parentBeanProcessor = parentBeanProcessor;
            this.beanData = beanData;
            this.beanName = beanName;
            this.when = when;
        }

        @Override
        public Object getBean() {
            Object previousBean = this.parentBeanCreator.getBean();
            Object processed = null;
            switch (this.when) {
                case Before: {
                    processed = this.parentBeanProcessor.beforeInit(previousBean, this.beanName, this.parentBeanCreator, this.beanData);
                    break;
                }
                case After: {
                    processed = this.parentBeanProcessor.afterInit(previousBean, this.beanName, this.parentBeanCreator, this.beanData);
                }
            }
            return processed;
        }

        public static enum ChainType {
            Before,
            After;

        }
    }

    private class TIConverter
    implements TypeInference.Converter {
        private TIConverter() {
        }

        @Override
        public TypeInference.TypedObject convert(TypeInference.TypedObject from, Type to) throws Exception {
            Object arg = BeanRecipe.this.convert(from.getValue(), from.getType(), to);
            return new TypeInference.TypedObject(to, arg);
        }
    }

    public class VoidableCallable
    implements Callable<Object>,
    Voidable {
        private final AtomicReference<Object> ref = new AtomicReference();
        private final Semaphore sem = new Semaphore(1);
        private final ThreadLocal<Object> deadlockDetector = new ThreadLocal();

        @Override
        public void voidReference() {
            this.ref.set(null);
        }

        @Override
        public Object call() throws ComponentDefinitionException {
            Object o;
            block8: {
                o = this.ref.get();
                if (o == null) {
                    if (this.deadlockDetector.get() != null) {
                        this.deadlockDetector.remove();
                        throw new ComponentDefinitionException("Construction cycle detected for bean " + BeanRecipe.this.name);
                    }
                    this.sem.acquireUninterruptibly();
                    try {
                        o = this.ref.get();
                        if (o != null) break block8;
                        this.deadlockDetector.set(this);
                        try {
                            o = BeanRecipe.this.internalCreate2();
                            this.ref.set(o);
                        }
                        finally {
                            this.deadlockDetector.remove();
                        }
                    }
                    finally {
                        this.sem.release();
                    }
                }
            }
            return o;
        }
    }

    static class UnwrapperedBeanHolder {
        final Object unwrapperedBean;
        final BeanRecipe recipe;

        public UnwrapperedBeanHolder(Object unwrapperedBean, BeanRecipe recipe) {
            this.unwrapperedBean = unwrapperedBean;
            this.recipe = recipe;
        }
    }
}

