/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.components.ColoredRadioButton;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.color.QuickColorChooser;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Color;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioColorChooser {
    private final ToolTipContext toolTipContext = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH);
    private final ButtonGroup bg = new ButtonGroup();
    private final List<ColoredRadioButton> radioButtons;
    private final ColoredRadioButton defaultButton;
    private final ColoredRadioButton customButton;
    private final List<ColorSpec> colors;
    private final Color defaultColor;

    public RadioColorChooser(@NotNull List<ColorSpec> colors, @NotNull ColorSpec customColorSpec, @Nullable Color currentColor, @NotNull Color defaultColor) {
        if (colors.isEmpty()) {
            throw new IllegalArgumentException("Must pass at least one color");
        }
        this.colors = colors;
        this.defaultColor = defaultColor;
        ColoredRadioButton[] buttons = new ColoredRadioButton[colors.size() + 1];
        for (int i = 0; i < buttons.length - 1; ++i) {
            buttons[i] = this.createRadioButton(colors.get(i));
        }
        final Supplier<Color> colorSupplier = () -> currentColor != null ? currentColor : defaultColor;
        ColoredRadioButton customButton = new ColoredRadioButton(null, null){
            {
                super(text, color);
                this.addActionListener(e -> this.getColor());
            }

            @Override
            public Color getColor() {
                Color c = super.getColor();
                if (c == null) {
                    Color color = (Color)colorSupplier.get();
                    this.setColors(color, color);
                }
                return super.getColor();
            }
        };
        QuickColorChooser.attachToComponent(customButton, customButton::setColor, () -> Optional.ofNullable(customButton.getColor()).orElse((Color)colorSupplier.get()), customButton::isSelected);
        buttons[buttons.length - 1] = this.createRadioButton(customColorSpec, customButton);
        this.radioButtons = Arrays.asList(buttons);
        this.customButton = customButton;
        this.defaultButton = buttons[0];
    }

    public List<ColorSpec> getColors() {
        return this.colors;
    }

    public List<ColoredRadioButton> getRadioButtons() {
        return this.radioButtons;
    }

    public void setColor(Color color) {
        if (color == null) {
            this.defaultButton.setSelected(true);
            return;
        }
        if (!this.updateSelection(color)) {
            this.customButton.setSelected(true);
            if (this.customButton.getColor() == null) {
                this.customButton.setColor(color);
            }
        }
    }

    public Color getSelectedColor() {
        Enumeration<AbstractButton> buttons = this.bg.getElements();
        while (buttons.hasMoreElements()) {
            ColoredRadioButton button = (ColoredRadioButton)buttons.nextElement();
            if (!button.isSelected()) continue;
            if (button == this.defaultButton) {
                return this.defaultColor;
            }
            return button.getColor();
        }
        return this.defaultColor;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setEnabled(boolean enabled) {
        Enumeration<AbstractButton> buttons = this.bg.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().setEnabled(enabled);
        }
    }

    private boolean updateSelection(Color color) {
        Enumeration<AbstractButton> buttons = this.bg.getElements();
        while (buttons.hasMoreElements()) {
            ColoredRadioButton radioButton = (ColoredRadioButton)buttons.nextElement();
            boolean selected = Objects.equals(radioButton.getColor(), color) || radioButton == this.defaultButton && Objects.equals(this.defaultColor, color);
            this.bg.setSelected(radioButton.getModel(), selected);
            if (!selected) continue;
            return true;
        }
        return false;
    }

    private ColoredRadioButton createRadioButton(ColorSpec colorSpec, ColoredRadioButton button) {
        DynamicUI.withDynamic(button, c -> {
            String name = UIManager.getString((Object)colorSpec.nameKey, c.getLocale());
            c.setName(name);
            c.setToolTipText(name);
        });
        button.putClientProperty("JToolTip.style", "balloon");
        button.putClientProperty("JToolTip.toolTipContext", this.toolTipContext);
        this.bg.add(button);
        return button;
    }

    private ColoredRadioButton createRadioButton(ColorSpec colorSpec) {
        return this.createRadioButton(colorSpec, new ColoredRadioButton("", colorSpec.color, colorSpec.focusColor != null ? colorSpec.focusColor : colorSpec.color));
    }

    public static class ColorSpec {
        @NotNull
        public final Color color;
        @Nullable
        public final Color focusColor;
        @Nullable
        public final String nameKey;

        public ColorSpec(@NotNull Color color, @Nullable Color focusColor, @Nullable String nameKey) {
            this.color = color;
            this.focusColor = focusColor;
            this.nameKey = nameKey;
        }
    }
}

