/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData;

import java.util.HashMap;
import java.util.Iterator;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.ChartType;

public abstract class AxisDataSeries
implements IAxisDataSeries,
HTMLTestable {
    private String chartTitle;
    private String xAxisTitle;
    private String yAxisTitle;
    protected HashMap dataSets;
    protected int totalNumberOfDataSets;
    private int sizeOfEachDataSet;

    public AxisDataSeries(String string, String string2, String string3) {
        this.xAxisTitle = string;
        this.yAxisTitle = string2;
        this.chartTitle = string3;
        this.dataSets = new HashMap();
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public IAxisPlotDataSet getIAxisPlotDataSet(ChartType chartType) {
        return (IAxisPlotDataSet)this.dataSets.get(chartType);
    }

    public Iterator getIAxisPlotDataSetIterator() {
        return this.dataSets.values().iterator();
    }

    public int getTotalNumberOfDataSets() {
        return this.totalNumberOfDataSets;
    }

    public void addIAxisPlotDataSet(IAxisPlotDataSet iAxisPlotDataSet) {
        this.dataSets.put(iAxisPlotDataSet.getChartType(), iAxisPlotDataSet);
        this.totalNumberOfDataSets += iAxisPlotDataSet.getNumberOfDataSets();
        this.sizeOfEachDataSet = iAxisPlotDataSet.getNumberOfDataItems();
    }

    public void validate() throws ChartDataException, PropertyException {
        Iterator iterator = this.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
            iAxisPlotDataSet.validate();
            if (iAxisPlotDataSet.getNumberOfDataItems() == this.sizeOfEachDataSet) continue;
            throw new ChartDataException("All IAxisPlotDataSet implementations must contain an equal number of elements in a Combo Chart");
        }
    }

    public int getSizeOfEachDataSet() {
        return this.sizeOfEachDataSet;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableRowStart();
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        hTMLGenerator.addTableRow("chart title", this.chartTitle);
        hTMLGenerator.addTableRow("xAxisTitle", this.xAxisTitle);
        hTMLGenerator.addTableRow("yAxisTitle", this.yAxisTitle);
        hTMLGenerator.propertiesTableEnd();
        hTMLGenerator.propertiesTableRowEnd();
    }

    public int size() {
        return this.dataSets.size();
    }
}

