/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.util.Collection;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementSchema;
import org.apiguardian.api.API;

public interface JMeterGUIComponent
extends ClearGui {
    public void setName(String var1);

    public String getName();

    public String getStaticLabel();

    public String getLabelResource();

    public String getDocAnchor();

    @API(status=API.Status.EXPERIMENTAL, since="5.6.3")
    default public TestElement createTestElement() {
        TestElement element = this.makeTestElement();
        this.assignDefaultValues(element);
        return element;
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.6.3")
    default public TestElement makeTestElement() {
        throw new UnsupportedOperationException("Please override makeTestElement with creating the element you need: return new ....");
    }

    default public void assignDefaultValues(TestElement element) {
        element.setName((String)StringUtils.defaultIfEmpty((CharSequence)this.getStaticLabel(), null));
        TestElementSchema.INSTANCE schema = TestElementSchema.INSTANCE;
        element.set(schema.getGuiClass(), this.getClass());
        element.set(schema.getTestClass(), element.getClass());
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.6.3")
    default public void modifyTestElement(TestElement element) {
        element.clear();
        element.setName((String)StringUtils.defaultIfEmpty((CharSequence)this.getName(), null));
        TestElementSchema.INSTANCE schema = TestElementSchema.INSTANCE;
        element.set(schema.getGuiClass(), this.getClass());
        element.set(schema.getTestClass(), element.getClass());
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public JPopupMenu createPopupMenu();

    public void configure(TestElement var1);

    public Collection<String> getMenuCategories();

    default public boolean canBeAdded() {
        return true;
    }
}

