/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.Set;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.index.HashIndexTable;
import org.apache.jena.sparql.engine.index.IndexTable;
import org.apache.jena.sparql.engine.index.LinearIndex;
import org.apache.jena.sparql.engine.index.SetIndexTable;

public class IndexFactory {
    public static IndexTable createIndex(Set<Var> commonVars, QueryIterator data) {
        try {
            if (commonVars.size() == 1) {
                return new SetIndexTable(commonVars, data);
            }
            return new HashIndexTable(commonVars, data);
        }
        catch (HashIndexTable.MissingBindingException e2) {
            return new LinearIndex(commonVars, data, e2.getData(), e2.getMap());
        }
    }
}

