/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIx;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class ParameterizedSparqlString
implements PrefixMapping {
    private static final Node UNDEF = NodeFactory.createURI((String)"urn:x-arq:undef");
    private Model model = ModelFactory.createDefaultModel();
    private final RDFNode undef = this.model.wrapAsResource(UNDEF);
    private StringBuilder cmd = new StringBuilder();
    private String baseUri;
    private Map<String, Node> params = new HashMap<String, Node>();
    private Map<Integer, Node> positionalParams = new HashMap<Integer, Node>();
    private PrefixMapping prefixes;
    private Map<String, ValueReplacement> valuesReplacements = new HashMap<String, ValueReplacement>();
    private Syntax syntax = Syntax.defaultQuerySyntax;
    private static final String VALUES_KEYWORD = "values";

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base, PrefixMapping prefixes) {
        if (command != null) {
            this.cmd.append(command);
        }
        this.setParams(map);
        this.baseUri = base != null && !base.equals("") ? base : null;
        this.prefixes = new PrefixMappingImpl();
        if (prefixes != null) {
            this.prefixes.setNsPrefixes(prefixes);
        }
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base) {
        this(command, map, base, null);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, PrefixMapping prefixes) {
        this(command, map, null, prefixes);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map) {
        this(command, map, null, null);
    }

    public ParameterizedSparqlString(String command, String base, PrefixMapping prefixes) {
        this(command, null, base, prefixes);
    }

    public ParameterizedSparqlString(String command, PrefixMapping prefixes) {
        this(command, null, null, prefixes);
    }

    public ParameterizedSparqlString(String command, String base) {
        this(command, null, base, null);
    }

    public ParameterizedSparqlString(String command) {
        this(command, null, null, null);
    }

    public ParameterizedSparqlString(QuerySolutionMap map, PrefixMapping prefixes) {
        this(null, map, null, prefixes);
    }

    public ParameterizedSparqlString(QuerySolutionMap map) {
        this(null, map, null, null);
    }

    public ParameterizedSparqlString(PrefixMapping prefixes) {
        this(null, null, null, prefixes);
    }

    public ParameterizedSparqlString() {
        this("", null, null, null);
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        if (syntax == null) {
            return;
        }
        this.syntax = syntax;
    }

    public void setCommandText(String command) {
        this.cmd = new StringBuilder();
        this.cmd.append(command);
    }

    public void append(String text) {
        this.cmd.append(text);
    }

    public void append(char c) {
        this.cmd.append(c);
    }

    public void append(boolean b) {
        this.cmd.append(b);
    }

    public void append(double d) {
        this.cmd.append(d);
    }

    public void append(float f) {
        this.cmd.append(f);
    }

    public void append(int i) {
        this.cmd.append(i);
    }

    public void append(long l) {
        this.cmd.append(l);
    }

    public void append(Object obj) {
        this.cmd.append(obj);
    }

    public void appendNode(Node n) {
        SerializationContext context2 = new SerializationContext(this.prefixes, this.baseUri);
        this.cmd.append(this.stringForNode(n, context2));
    }

    public void appendNode(RDFNode n) {
        this.appendNode(n.asNode());
    }

    public void appendIri(String uri) {
        this.appendNode(NodeFactory.createURI((String)uri));
    }

    public void appendIri(IRIx iri) {
        this.appendNode(NodeFactory.createURI((String)iri.toString()));
    }

    public void appendLiteral(String value) {
        this.appendNode(NodeFactory.createLiteralString((String)value));
    }

    public void appendLiteral(String value, String lang) {
        this.appendNode(NodeFactory.createLiteralLang((String)value, (String)lang));
    }

    public void appendLiteral(String value, String lang, String direction) {
        this.appendNode(NodeFactory.createLiteralDirLang((String)value, (String)lang, (String)direction));
    }

    public void appendLiteral(String value, RDFDatatype datatype) {
        this.appendNode(NodeFactory.createLiteralDT((String)value, (RDFDatatype)datatype));
    }

    public void appendLiteral(boolean b) {
        this.appendNode((RDFNode)this.model.createTypedLiteral(b));
    }

    public void appendLiteral(int i) {
        this.appendNode(NodeFactoryExtra.intToNode(i));
    }

    public void appendLiteral(long l) {
        this.appendNode(NodeFactoryExtra.intToNode(l));
    }

    public void appendLiteral(float f) {
        this.appendNode((RDFNode)this.model.createTypedLiteral(f));
    }

    public void appendLiteral(double d) {
        this.appendNode((RDFNode)this.model.createTypedLiteral(d));
    }

    public void appendLiteral(Calendar dt) {
        this.appendNode((RDFNode)this.model.createTypedLiteral(dt));
    }

    public String getCommandText() {
        return this.cmd.toString();
    }

    public void setBaseUri(String base) {
        this.baseUri = base;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public RDFNode undef() {
        return this.undef;
    }

    protected void validateParameterValue(Node n) {
        if (n.isURI() && n.getURI().contains(">")) {
            throw new ARQException("Value for the parameter contains a SPARQL injection risk");
        }
    }

    public void setParams(QuerySolutionMap map) {
        if (map != null) {
            Iterator<String> iter = map.varNames();
            while (iter.hasNext()) {
                String var = iter.next();
                this.setParam(var, map.get(var).asNode());
            }
        }
    }

    public void setParam(int index, Node n) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n != null) {
            this.validateParameterValue(n);
            this.positionalParams.put(index, n);
        } else {
            this.positionalParams.remove(index);
        }
    }

    public void setParam(String var, Node n) {
        if (var == null) {
            throw new IllegalArgumentException("var cannot be null");
        }
        if (var.startsWith("?") || var.startsWith("$")) {
            var = var.substring(1);
        }
        if (n != null) {
            this.validateParameterValue(n);
            this.params.put(var, n);
        } else {
            this.params.remove(var);
        }
    }

    public void setParam(int index, RDFNode n) {
        this.setParam(index, n.asNode());
    }

    public void setParam(String var, RDFNode n) {
        this.setParam(var, n.asNode());
    }

    public void setIri(int index, String iri) {
        this.setParam(index, NodeFactory.createURI((String)iri));
    }

    public void setIri(String var, String iri) {
        this.setParam(var, NodeFactory.createURI((String)iri));
    }

    public void setIri(int index, IRIx iri) {
        this.setIri(index, iri.toString());
    }

    public void setIri(String var, IRIx iri) {
        this.setIri(var, iri.toString());
    }

    public void setIri(int index, URL url) {
        this.setIri(index, url.toString());
    }

    public void setIri(String var, URL url) {
        this.setIri(var, url.toString());
    }

    public void setLiteral(int index, Literal lit) {
        this.setParam(index, lit.asNode());
    }

    public void setLiteral(String var, Literal lit) {
        this.setParam(var, lit.asNode());
    }

    public void setLiteral(int index, String value) {
        this.setParam(index, NodeFactory.createLiteralString((String)value));
    }

    public void setLiteral(String var, String value) {
        this.setParam(var, NodeFactory.createLiteralString((String)value));
    }

    public void setLiteral(int index, String value, String lang) {
        this.setParam(index, NodeFactory.createLiteralLang((String)value, (String)lang));
    }

    public void setLiteral(String var, String value, String lang, String baseDirection) {
        this.setParam(var, NodeFactory.createLiteralDirLang((String)value, (String)lang, (String)baseDirection));
    }

    public void setLiteral(int index, String value, String lang, String baseDirection) {
        this.setParam(index, NodeFactory.createLiteralDirLang((String)value, (String)lang, (String)baseDirection));
    }

    public void setLiteral(String var, String value, String lang) {
        this.setParam(var, NodeFactory.createLiteralLang((String)value, (String)lang));
    }

    public void setLiteral(int index, String value, RDFDatatype datatype) {
        this.setParam(index, NodeFactory.createLiteralDT((String)value, (RDFDatatype)datatype));
    }

    public void setLiteral(String var, String value, RDFDatatype datatype) {
        this.setParam(var, NodeFactory.createLiteralDT((String)value, (RDFDatatype)datatype));
    }

    public void setLiteral(int index, boolean value) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(value));
    }

    public void setLiteral(String var, boolean value) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(value));
    }

    public void setLiteral(int index, int i) {
        this.setParam(index, NodeFactoryExtra.intToNode(i));
    }

    public void setLiteral(String var, int i) {
        this.setParam(var, NodeFactoryExtra.intToNode(i));
    }

    public void setLiteral(int index, long l) {
        this.setParam(index, NodeFactoryExtra.intToNode(l));
    }

    public void setLiteral(String var, long l) {
        this.setParam(var, NodeFactoryExtra.intToNode(l));
    }

    public void setLiteral(int index, float f) {
        this.setParam(index, NodeFactoryExtra.floatToNode(f));
    }

    public void setLiteral(String var, float f) {
        this.setParam(var, NodeFactoryExtra.floatToNode(f));
    }

    public void setLiteral(int index, double d) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(d));
    }

    public void setLiteral(String var, double d) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(d));
    }

    public void setLiteral(int index, Calendar dt) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(dt));
    }

    public void setLiteral(String var, Calendar dt) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(dt));
    }

    public Node getParam(String var) {
        return this.params.get(var);
    }

    public Node getParam(int index) {
        return this.positionalParams.get(index);
    }

    public Iterator<String> getVars() {
        return this.params.keySet().iterator();
    }

    public Map<String, Node> getVariableParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public Map<Integer, Node> getPositionalParameters() {
        return Collections.unmodifiableMap(this.positionalParams);
    }

    public Iterator<Integer> getEligiblePositionalParameters() {
        Pattern p = Pattern.compile("(\\?)[\\s;,.]");
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int index = 0;
        Matcher matcher = p.matcher(this.cmd.toString());
        while (matcher.find()) {
            positions.add(index);
            ++index;
        }
        return positions.iterator();
    }

    public void clearParam(String var) {
        this.params.remove(var);
        this.valuesReplacements.remove(var);
    }

    public void clearParam(int index) {
        this.positionalParams.remove(index);
    }

    public void clearParams() {
        this.params.clear();
        this.valuesReplacements.clear();
        this.positionalParams.clear();
    }

    protected void validateSafeToInject(String command, String var, Node n) throws ARQException {
        Pattern p = Pattern.compile("\"[?$]" + var + "\"|'[?$]" + var + "'");
        if (p.matcher(command).find() && n.isLiteral()) {
            throw new ARQException("Command string is vulnerable to injection attack, variable ?" + var + " appears surrounded directly by quotes and is bound to a literal which provides a SPARQL injection attack vector");
        }
        DelimiterInfo delims = this.findDelimiters(command);
        p = Pattern.compile("([?$]" + var + ")([^\\w]|$)");
        Matcher matcher = p.matcher(command);
        while (matcher.find()) {
            MatchResult posMatch = matcher.toMatchResult();
            if (!n.isLiteral() || !delims.isInsideLiteral(posMatch.start(1), posMatch.end(1))) continue;
            throw new ARQException("Command string is vulnerable to injection attack, variable ?" + var + " appears inside of a literal and is bound to a literal which provides a SPARQL injection attack vector");
        }
    }

    protected void validateSafeToInject(String command, int index, int position, Node n) throws ARQException {
        DelimiterInfo delims = this.findDelimiters(command);
        if (n.isLiteral() && delims.isInsideLiteral(position, position)) {
            throw new ARQException("Command string is vulnerable to injection attack, a positional parameter (index " + index + ") appears inside of a literal and is bound to a literal which provides a SPARQL injection attack vector");
        }
    }

    protected final DelimiterInfo findDelimiters(String command) {
        DelimiterInfo delims = new DelimiterInfo(this);
        delims.parseFrom(command);
        return delims;
    }

    protected final String stringForNode(Node n, SerializationContext context2) {
        if (n == UNDEF) {
            return "UNDEF";
        }
        String str2 = FmtUtils.stringForNode(n, context2);
        if (n.isLiteral() && str2.contains("'")) {
            str2 = str2.replace("'", "\\'");
        }
        return str2;
    }

    public String toString() {
        Pattern p;
        Object command = this.cmd.toString();
        SerializationContext context2 = new SerializationContext(this.prefixes, this.baseUri);
        for (String var : this.params.keySet()) {
            Node n = this.params.get(var);
            if (n == null) continue;
            this.validateSafeToInject((String)command, var, n);
            p = Pattern.compile("([?$]" + var + ")([^\\w]|$)");
            command = p.matcher((CharSequence)command).replaceAll(Matcher.quoteReplacement(this.stringForNode(n, context2)) + "$2");
        }
        command = this.applyValues((String)command, context2);
        p = Pattern.compile("(\\?)[\\s;,.]");
        int index = -1;
        int adj = 0;
        Matcher matcher = p.matcher((CharSequence)command);
        while (matcher.find()) {
            Node n;
            MatchResult posMatch = matcher.toMatchResult();
            if ((n = this.positionalParams.get(++index)) == null) continue;
            this.validateSafeToInject((String)command, index, posMatch.start(1) + adj, n);
            String nodeStr = this.stringForNode(n, context2);
            command = ((String)command).substring(0, posMatch.start() + adj) + nodeStr + ((String)command).substring(posMatch.start() + adj + 1);
            adj += nodeStr.length() - 1;
        }
        StringBuilder finalCmd = new StringBuilder();
        if (this.baseUri != null) {
            finalCmd.append("BASE ");
            finalCmd.append(FmtUtils.stringForURI(this.baseUri, null, null));
            finalCmd.append('\n');
        }
        for (String prefix : this.prefixes.getNsPrefixMap().keySet()) {
            finalCmd.append("PREFIX ");
            finalCmd.append(prefix);
            finalCmd.append(": ");
            finalCmd.append(FmtUtils.stringForURI(this.prefixes.getNsPrefixURI(prefix), null, null));
            finalCmd.append('\n');
        }
        finalCmd.append((String)command);
        return finalCmd.toString();
    }

    public Query asQuery() throws QueryException {
        return this.asQuery(this.syntax);
    }

    public Query asQuery(Syntax syntax) {
        return QueryFactory.create(this.toString(), syntax);
    }

    public UpdateRequest asUpdate() {
        return this.asUpdate(this.syntax);
    }

    public UpdateRequest asUpdate(Syntax syntax) {
        return UpdateFactory.create(this.toString(), syntax);
    }

    public ParameterizedSparqlString copy() {
        return this.copy(true, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams) {
        return this.copy(copyParams, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams, boolean copyBase, boolean copyPrefixes) {
        ParameterizedSparqlString copy = new ParameterizedSparqlString(this.cmd.toString(), null, copyBase ? this.baseUri : null, copyPrefixes ? this.prefixes : null);
        if (copyParams) {
            Iterator<String> vars = this.getVars();
            while (vars.hasNext()) {
                String var = vars.next();
                copy.setParam(var, this.getParam(var));
            }
            for (Map.Entry<Integer, Node> entry : this.positionalParams.entrySet()) {
                copy.setParam((int)entry.getKey(), entry.getValue());
            }
        }
        copy.setSyntax(copy.getSyntax());
        return copy;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        return this.prefixes.setNsPrefix(prefix, uri);
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        return this.prefixes.removeNsPrefix(prefix);
    }

    public PrefixMapping clearNsPrefixMap() {
        return this.prefixes.clearNsPrefixMap();
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.prefixes.setNsPrefixes(other);
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        return this.prefixes.setNsPrefixes(map);
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        return this.prefixes.withDefaultMappings(map);
    }

    public String getNsPrefixURI(String prefix) {
        return this.prefixes.getNsPrefixURI(prefix);
    }

    public String getNsURIPrefix(String uri) {
        return this.prefixes.getNsURIPrefix(uri);
    }

    public Map<String, String> getNsPrefixMap() {
        return this.prefixes.getNsPrefixMap();
    }

    public String expandPrefix(String prefixed) {
        return this.prefixes.expandPrefix(prefixed);
    }

    public String shortForm(String uri) {
        return this.prefixes.shortForm(uri);
    }

    public String qnameFor(String uri) {
        return this.prefixes.qnameFor(uri);
    }

    public boolean hasNoMappings() {
        return this.prefixes.hasNoMappings();
    }

    public int numPrefixes() {
        return this.prefixes.numPrefixes();
    }

    public PrefixMapping lock() {
        return this.prefixes.lock();
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.prefixes.samePrefixMappingAs(other);
    }

    public void setValues(String valueName, Collection<? extends RDFNode> items) {
        items.forEach(item -> this.validateParameterValue(item.asNode()));
        ArrayList<List<? extends RDFNode>> rowItems = new ArrayList<List<? extends RDFNode>>();
        if (items instanceof List) {
            rowItems.add((List)items);
        } else {
            rowItems.add(new ArrayList<RDFNode>(items));
        }
        this.valuesReplacements.put(valueName, new ValueReplacement(valueName, rowItems));
    }

    public void setValues(String valueName, RDFNode item) {
        this.setValues(valueName, Arrays.asList(item));
    }

    public void setValues(Map<String, Collection<? extends RDFNode>> itemsMap) {
        itemsMap.forEach(this::setValues);
    }

    public void setRowValues(String valueName, Collection<List<? extends RDFNode>> rowItems) {
        rowItems.forEach(collection -> collection.forEach(item -> this.validateParameterValue(item.asNode())));
        this.valuesReplacements.put(valueName, new ValueReplacement(valueName, rowItems));
    }

    private String applyValues(String command, SerializationContext context2) {
        for (ValueReplacement valueReplacement : this.valuesReplacements.values()) {
            command = valueReplacement.apply(command, context2);
        }
        return command;
    }

    protected static String[] extractTargetVars(String command, String valueName) {
        String[] targetVars = new String[]{};
        int valueIndex = command.indexOf(valueName);
        if (valueIndex > -1) {
            String subCmd = command.substring(0, valueIndex).toLowerCase();
            int valuesIndex = subCmd.lastIndexOf(VALUES_KEYWORD);
            int openBracesIndex = subCmd.lastIndexOf("{");
            int closeBracesIndex = subCmd.lastIndexOf("}");
            if (valuesIndex > -1 && valuesIndex < openBracesIndex && closeBracesIndex < valuesIndex) {
                String vars = command.substring(valuesIndex + VALUES_KEYWORD.length(), openBracesIndex);
                targetVars = vars.replaceAll("[(?$)]", "").trim().split(" ");
            }
        }
        return targetVars;
    }

    private class DelimiterInfo {
        private List<Pair<Integer, String>> starts = new ArrayList<Pair<Integer, String>>();
        private Map<Integer, Integer> stops = new HashMap<Integer, Integer>();

        private DelimiterInfo(ParameterizedSparqlString parameterizedSparqlString) {
        }

        public void parseFrom(String command) {
            this.starts.clear();
            this.stops.clear();
            char[] cs = command.toCharArray();
            block7: for (int i = 0; i < cs.length; ++i) {
                switch (cs[i]) {
                    case '\"': {
                        int j;
                        if (i < cs.length - 2 && cs[i + 1] == '\"' && cs[i + 2] == '\"') {
                            this.addStart(i, "\"\"\"");
                            for (j = i + 3; j < cs.length - 2; ++j) {
                                if (cs[j] != '\"' || cs[j + 1] != '\"' || cs[j + 2] != '\"') continue;
                                this.addStop(i, j + 2);
                                i = j + 2;
                                continue block7;
                            }
                            continue block7;
                        }
                        this.addStart(i, "\"");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\"' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                            continue block7;
                        }
                        continue block7;
                    }
                    case '<': {
                        int j;
                        this.addStart(i, "<");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '>' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                            continue block7;
                        }
                        continue block7;
                    }
                    case '\'': {
                        int j;
                        if (i < cs.length - 2 && cs[i + 1] == '\'' && cs[i + 2] == '\'') {
                            this.addStart(i, "'''");
                            for (j = i + 3; j < cs.length - 2; ++j) {
                                if (cs[j] != '\'' || cs[j + 1] != '\'' || cs[j + 2] != '\'') continue;
                                this.addStop(i, j + 2);
                                i = j + 2;
                                continue block7;
                            }
                            continue block7;
                        }
                        this.addStart(i, "'");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\'' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                            continue block7;
                        }
                        continue block7;
                    }
                    case '#': {
                        int j;
                        this.addStart(i, "#");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\n' && cs[j] != '\r') continue;
                            this.addStop(i, j);
                            i = j;
                            break;
                        }
                        this.addStop(i, cs.length - 1);
                        continue block7;
                    }
                    case '\n': 
                    case '\r': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '.': 
                    case ';': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.addStart(i, new String(new char[]{cs[i]}));
                        this.addStop(i, i);
                    }
                }
            }
        }

        public void addStart(int index, String delim) {
            this.starts.add((Pair<Integer, String>)new Pair((Object)index, (Object)delim));
        }

        public void addStop(int start, int stop) {
            this.stops.put(start, stop);
        }

        public Pair<Integer, String> findBefore(int index) {
            Pair<Integer, String> found = null;
            for (Pair<Integer, String> pair : this.starts) {
                if ((Integer)pair.getLeft() < index) {
                    found = pair;
                }
                if ((Integer)pair.getLeft() < index) continue;
                break;
            }
            return found;
        }

        public Pair<Integer, String> findAfter(int index) {
            for (Pair<Integer, String> pair : this.starts) {
                if ((Integer)pair.getLeft() <= index) continue;
                return pair;
            }
            return null;
        }

        public boolean isInsideLiteral(int start, int stop) {
            Pair<Integer, String> pair = this.findBefore(start);
            if (pair == null) {
                return false;
            }
            if (((String)pair.getRight()).equals("\"")) {
                Integer nearestStop = this.stops.get(pair.getLeft());
                if (nearestStop == null) {
                    return true;
                }
                return nearestStop > stop;
            }
            return false;
        }

        public boolean isInsideAltLiteral(int start, int stop) {
            Pair<Integer, String> pair = this.findBefore(start);
            if (pair == null) {
                return false;
            }
            if (((String)pair.getRight()).equals("'")) {
                Integer nearestStop = this.stops.get(pair.getLeft());
                if (nearestStop == null) {
                    return true;
                }
                return nearestStop > stop;
            }
            return false;
        }

        public boolean isBetweenLiterals(int start, int stop) {
            Pair<Integer, String> pairBefore = this.findBefore(start);
            if (pairBefore == null) {
                return false;
            }
            if (((String)pairBefore.getRight()).equals("\"")) {
                Integer stopBefore = this.stops.get(pairBefore.getLeft());
                if (stopBefore == null) {
                    return false;
                }
                Pair<Integer, String> pairAfter = this.findAfter(stop);
                return pairAfter != null && ((String)pairAfter.getRight()).equals("\"");
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Pair<Integer, String> pair : this.starts) {
                builder.append("Delim ");
                builder.append((String)pair.getRight());
                builder.append(" - Start ");
                builder.append(pair.getLeft());
                builder.append(" - End ");
                builder.append(this.stops.get(pair.getLeft()));
                builder.append('\n');
            }
            return builder.toString();
        }
    }

    private class ValueReplacement {
        private final String valueName;
        private final Collection<List<? extends RDFNode>> rowItems;

        public ValueReplacement(String valueName, Collection<List<? extends RDFNode>> rowItems) {
            this.valueName = valueName;
            this.rowItems = rowItems;
        }

        public String apply(String command, SerializationContext context2) {
            if (this.rowItems.isEmpty()) {
                return command;
            }
            String[] targetVars = ParameterizedSparqlString.extractTargetVars(command, this.valueName);
            if (targetVars.length == 0) {
                return command;
            }
            this.validateValuesSafeToInject(command, targetVars);
            String target = this.createTarget();
            String replacement = this.buildReplacement(targetVars.length, context2);
            return command.replaceAll(target, replacement);
        }

        private String buildReplacement(int targetVarCount, SerializationContext context2) {
            StringBuilder replacement = new StringBuilder("");
            if (targetVarCount == 1) {
                for (List<? extends RDFNode> row : this.rowItems) {
                    for (RDFNode rDFNode : row) {
                        replacement.append("(");
                        String insert = ParameterizedSparqlString.this.stringForNode(rDFNode.asNode(), context2);
                        replacement.append(insert);
                        replacement.append(") ");
                    }
                }
            } else {
                for (List<? extends RDFNode> row : this.rowItems) {
                    replacement.append("(");
                    for (RDFNode rDFNode : row) {
                        String insert = ParameterizedSparqlString.this.stringForNode(rDFNode.asNode(), context2);
                        replacement.append(insert);
                        replacement.append(" ");
                    }
                    replacement.deleteCharAt(replacement.length() - 1);
                    replacement.append(") ");
                }
            }
            if (replacement.length() > 0) {
                replacement.deleteCharAt(replacement.length() - 1);
            }
            return replacement.toString();
        }

        private String createTarget() {
            Object target = this.valueName.startsWith("?") || this.valueName.startsWith("$") ? this.valueName : "[?$]" + this.valueName;
            return target;
        }

        protected void validateValuesSafeToInject(String command, String[] targetVars) {
            if (targetVars.length == 1) {
                String targetVar = targetVars[0];
                for (List<? extends RDFNode> row : this.rowItems) {
                    for (RDFNode rDFNode : row) {
                        ParameterizedSparqlString.this.validateSafeToInject(command, targetVar, rDFNode.asNode());
                    }
                }
            } else {
                for (int i = 0; i < targetVars.length; ++i) {
                    String targetVar = targetVars[i];
                    for (List<? extends RDFNode> row : this.rowItems) {
                        if (targetVars.length == row.size()) {
                            RDFNode rDFNode = row.get(i);
                            ParameterizedSparqlString.this.validateSafeToInject(command, targetVar, rDFNode.asNode());
                            continue;
                        }
                        String string = row.stream().map(RDFNode::toString).collect(Collectors.joining(","));
                        throw new ARQException("Number of VALUES variables (" + String.join((CharSequence)", ", targetVars) + ") does not equal replacement row (" + string + ").");
                    }
                }
            }
        }
    }
}

