/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.servlet.jackrabbit.JackrabbitRepositoryServlet;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.JcrClient;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    private final CommandLine command;
    private final RequestLogHandler accessLog;
    private final WebAppContext webapp;
    private final Server server;
    private final ServerConnector connector;
    private final File repository;
    private final File log;

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CommandLine command = Main.createCommand(args, options);
        File jarFile = Main.findJarFileLocation(command);
        if (command.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar " + jarFile.getName(), options, true);
        } else if (command.hasOption("notice")) {
            Main.copyToOutput("/META-INF/NOTICE.txt");
        } else if (command.hasOption("license")) {
            Main.copyToOutput("/META-INF/LICENSE.txt");
        } else if (command.hasOption("cli")) {
            System.setProperty("logback.configurationFile", "logback-cli.xml");
            String uri = command.getOptionValue("cli");
            Repository repository = JcrUtils.getRepository(uri);
            ContextBase context = new ContextBase();
            CommandHelper.setRepository(context, repository, uri);
            try {
                Session session = repository.login();
                CommandHelper.setSession(context, session);
                CommandHelper.setCurrentNode(context, session.getRootNode());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            new JcrClient(context).runInteractive();
            try {
                CommandHelper.getSession(context).logout();
            }
            catch (CommandException commandException) {}
        } else {
            new Main(command).run(jarFile);
        }
    }

    private static CommandLine createCommand(String[] args, Options options) throws ParseException {
        options.addOption("?", "help", false, "print this message");
        options.addOption("n", "notice", false, "print copyright notices");
        options.addOption("l", "license", false, "print license information");
        options.addOption("b", "backup", false, "create a backup of the repository");
        options.addOption("i", "cli", true, "command line access to a remote repository");
        options.addOption("q", "quiet", false, "disable console output");
        options.addOption("d", "debug", false, "enable debug logging");
        options.addOption("h", "host", true, "IP address of the HTTP server");
        options.addOption("p", "port", true, "TCP port of the HTTP server (8080)");
        options.addOption("f", "file", true, "location of this jar file");
        options.addOption("r", "repo", true, "repository directory (jackrabbit)");
        options.addOption("c", "conf", true, "repository configuration file");
        options.addOption("R", "backup-repo", true, "backup repository directory (jackrabbit-backupN)");
        options.addOption("C", "backup-conf", true, "backup repository configuration file");
        return new DefaultParser().parse(options, args);
    }

    private static File findJarFileLocation(CommandLine command) {
        File file;
        String defaultFile = "jackrabbit-standalone.jar";
        URL location = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (location != null && "file".equals(location.getProtocol()) && (file = new File(location.getPath())).isFile()) {
            defaultFile = location.getPath();
        }
        return new File(command.getOptionValue("file", defaultFile));
    }

    private static void setSystemPropertyIfMissing(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    private Main(CommandLine command) throws ParseException {
        this.command = command;
        this.repository = new File(command.getOptionValue("repo", "jackrabbit"));
        this.repository.mkdirs();
        this.log = new File(this.repository, "log");
        this.log.mkdir();
        if (!command.hasOption("quiet")) {
            System.out.println("Using repository directory " + this.repository);
            System.out.println("Writing log messages to " + this.log);
        }
        Main.setSystemPropertyIfMissing("jackrabbit.log", new File(this.log, "jackrabbit.log").getPath());
        Main.setSystemPropertyIfMissing("jetty.log", new File(this.log, "jetty.log").getPath());
        if (command.hasOption("debug")) {
            Main.setSystemPropertyIfMissing("log.level", "DEBUG");
        } else {
            Main.setSystemPropertyIfMissing("log.level", "INFO");
        }
        Main.setSystemPropertyIfMissing("derby.stream.error.file", new File(this.log, "derby.log").getPath());
        this.accessLog = new RequestLogHandler();
        this.webapp = new WebAppContext();
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
    }

    protected Main(String[] args) throws ParseException {
        this(Main.createCommand(args, new Options()));
    }

    public void run() throws Exception {
        this.run(Main.findJarFileLocation(this.command));
    }

    private void run(File jarFile) throws Exception {
        this.message("Welcome to Apache Jackrabbit!");
        this.message("-------------------------------");
        if (this.command.hasOption("backup")) {
            this.backup(this.repository);
        } else {
            this.message("Starting the server...");
            File tmp = new File(this.repository, "tmp");
            tmp.mkdir();
            this.prepareWebapp(jarFile, this.repository, tmp);
            this.accessLog.setHandler(this.webapp);
            this.prepareAccessLog(this.log);
            this.server.setHandler(this.accessLog);
            this.prepareConnector();
            this.server.addConnector(this.connector);
            this.prepareShutdown();
            try {
                this.server.start();
                String host = this.connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                this.message("Apache Jackrabbit is now running at http://" + host + ":" + this.connector.getPort() + "/");
            }
            catch (Throwable t) {
                System.err.println("Unable to start the server: " + t.getMessage());
                System.exit(1);
            }
        }
    }

    public void shutdown() {
        try {
            this.message("Shutting down the server...");
            this.server.stop();
            this.server.join();
            this.message("-------------------------------");
            this.message("Goodbye from Apache Jackrabbit!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void backup(File sourceDir) throws Exception {
        File targetDir;
        RepositoryConfig source = this.command.hasOption("conf") ? RepositoryConfig.create(new File(this.command.getOptionValue("conf")), sourceDir) : RepositoryConfig.create(sourceDir);
        if (this.command.hasOption("backup-repo")) {
            targetDir = new File(this.command.getOptionValue("backup-repo"));
        } else {
            int i = 1;
            while ((targetDir = new File("jackrabbit-backup" + i++)).exists()) {
            }
        }
        RepositoryConfig target = this.command.hasOption("backup-conf") ? RepositoryConfig.install(new File(this.command.getOptionValue("backup-conf")), targetDir) : RepositoryConfig.install(targetDir);
        this.message("Creating a repository copy in " + targetDir);
        RepositoryCopier.copy(source, target);
        this.message("The repository has been successfully copied.");
    }

    private void prepareAccessLog(File log) {
        NCSARequestLog ncsa = new NCSARequestLog(new File(log, "access.log.yyyy_mm_dd").getPath());
        ncsa.setFilenameDateFormat("yyyy-MM-dd");
        this.accessLog.setRequestLog(ncsa);
    }

    private void prepareWebapp(File file, File repository, File tmp) {
        this.webapp.setContextPath("/");
        this.webapp.setWar(file.getPath());
        this.webapp.setExtractWAR(true);
        this.webapp.setTempDirectory(tmp);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault(this.server);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.annotations.AnnotationConfiguration");
        ServletHolder servlet = new ServletHolder(JackrabbitRepositoryServlet.class);
        servlet.setInitOrder(1);
        servlet.setInitParameter("repository.home", repository.getPath());
        String conf = this.command.getOptionValue("conf");
        if (conf != null) {
            servlet.setInitParameter("repository.config", conf);
        }
        this.webapp.addServlet(servlet, "/repository.properties");
    }

    private void prepareConnector() {
        String port = this.command.getOptionValue("port", "8080");
        this.connector.setPort(Integer.parseInt(port));
        String host = this.command.getOptionValue("host");
        if (host != null) {
            this.connector.setHost(host);
        }
    }

    private void prepareShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.this.shutdown();
            }
        });
    }

    private void message(String message) {
        if (!this.command.hasOption("quiet")) {
            System.out.println(message);
        }
    }

    private static void copyToOutput(String resource) throws IOException {
        try (InputStream stream = Main.class.getResourceAsStream(resource);){
            IOUtils.copy(stream, (OutputStream)System.out);
        }
    }
}

