/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.state.ChangeLog;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientItemStateManager
implements ItemStateCreationListener {
    private static final Logger log = LoggerFactory.getLogger(TransientItemStateManager.class);
    private final Set<ItemState> addedStates = new LinkedHashSet<ItemState>();
    private final Set<ItemState> modifiedStates = new LinkedHashSet<ItemState>();
    private final Set<ItemState> removedStates = new LinkedHashSet<ItemState>();
    private final Set<ItemState> staleStates = new LinkedHashSet<ItemState>();
    private final Set<Operation> operations = new LinkedHashSet<Operation>();

    TransientItemStateManager() {
    }

    Iterator<Operation> getOperations() {
        return this.operations.iterator();
    }

    void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    boolean hasPendingChanges() {
        return !this.operations.isEmpty();
    }

    ChangeLog getChangeLog(ItemState target, boolean throwOnStale) throws InvalidItemStateException, ConstraintViolationException, RepositoryException {
        if (target.getStatus() == 4) {
            String msg = "Cannot save/revert an item with status NEW (" + target + ").";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (throwOnStale && Status.isStale(target.getStatus())) {
            String msg = "Attempt to save/revert an item, that has been externally modified (" + target + ").";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
        LinkedHashSet<ItemState> affectedStates = new LinkedHashSet<ItemState>();
        HierarchyEntry he = target.getHierarchyEntry();
        if (he.getParent() == null) {
            if (throwOnStale && !this.staleStates.isEmpty()) {
                String msg = "Cannot save changes: States has been modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            affectedStates.addAll(this.staleStates);
            ops.addAll(this.operations);
            affectedStates.addAll(this.addedStates);
            affectedStates.addAll(this.modifiedStates);
            affectedStates.addAll(this.removedStates);
        } else {
            if (throwOnStale) {
                for (ItemState state : this.staleStates) {
                    if (!TransientItemStateManager.containedInTree(target, state)) continue;
                    String msg = "Cannot save changes: States has been modified externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
            }
            IteratorChain<ItemState> chain = new IteratorChain<ItemState>(this.addedStates.iterator(), this.removedStates.iterator(), this.modifiedStates.iterator());
            if (!throwOnStale) {
                chain.addIterator(this.staleStates.iterator());
            }
            while (chain.hasNext()) {
                ItemState state;
                state = (ItemState)chain.next();
                if (!TransientItemStateManager.containedInTree(target, state)) continue;
                affectedStates.add(state);
            }
            block2: for (Operation op : this.operations) {
                Collection<ItemState> opStates = op.getAffectedItemStates();
                for (ItemState state : opStates) {
                    if (!affectedStates.contains(state)) continue;
                    if (!affectedStates.containsAll(opStates)) {
                        String msg = "ChangeLog is not self contained.";
                        throw new ConstraintViolationException(msg);
                    }
                    ops.add(op);
                    continue block2;
                }
            }
        }
        ChangeLog cl = new ChangeLog(target, ops, affectedStates);
        return cl;
    }

    NodeState createNewNodeState(Name nodeName, String uniqueID, Name nodeTypeName, QNodeDefinition definition, NodeState parent) throws RepositoryException {
        NodeEntry ne = ((NodeEntry)parent.getHierarchyEntry()).addNewNodeEntry(nodeName, uniqueID, nodeTypeName, definition);
        try {
            parent.markModified();
        }
        catch (RepositoryException e) {
            ne.remove();
            throw e;
        }
        return ne.getNodeState();
    }

    PropertyState createNewPropertyState(Name propName, NodeState parent, QPropertyDefinition definition, QValue[] values, int propertyType) throws ItemExistsException, ConstraintViolationException, RepositoryException {
        NodeEntry nodeEntry = (NodeEntry)parent.getHierarchyEntry();
        PropertyEntry pe = nodeEntry.addNewPropertyEntry(propName, definition, values, propertyType);
        try {
            parent.markModified();
        }
        catch (RepositoryException e) {
            pe.remove();
            throw e;
        }
        return pe.getPropertyState();
    }

    void dispose() {
        this.addedStates.clear();
        this.modifiedStates.clear();
        this.removedStates.clear();
        this.staleStates.clear();
        this.operations.clear();
    }

    void dispose(ChangeLog subChangeLog) {
        Set<ItemState> affectedStates = subChangeLog.getAffectedStates();
        this.addedStates.removeAll(affectedStates);
        this.modifiedStates.removeAll(affectedStates);
        this.removedStates.removeAll(affectedStates);
        this.staleStates.removeAll(affectedStates);
        this.operations.removeAll(subChangeLog.getOperations());
    }

    private void removed(ItemState state) {
        if (!this.addedStates.remove(state)) {
            this.modifiedStates.remove(state);
        }
        this.removedStates.add(state);
    }

    private static boolean containedInTree(ItemState parent, ItemState state) {
        HierarchyEntry pHe;
        HierarchyEntry he = state.getHierarchyEntry();
        if (he == (pHe = parent.getHierarchyEntry()) || he.getParent() == pHe) {
            return true;
        }
        if (!parent.isNode() || he == pHe.getParent()) {
            return false;
        }
        for (NodeEntry pe = he.getParent(); pe != null; pe = pe.getParent()) {
            if (pe != pHe) continue;
            return true;
        }
        return false;
    }

    @Override
    public void statusChanged(ItemState state, int previousStatus) {
        switch (state.getStatus()) {
            case 1: {
                switch (previousStatus) {
                    case 2: {
                        this.modifiedStates.remove(state);
                        break;
                    }
                    case 3: {
                        this.removedStates.remove(state);
                        break;
                    }
                    case 5: {
                        this.staleStates.remove(state);
                        break;
                    }
                    case 4: {
                        this.addedStates.remove(state);
                    }
                }
                break;
            }
            case 2: {
                this.modifiedStates.add(state);
                break;
            }
            case 3: {
                this.removed(state);
                break;
            }
            case 8: {
                switch (previousStatus) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.removed(state);
                    }
                }
                state.removeListener(this);
                break;
            }
            case 5: 
            case 6: {
                this.modifiedStates.remove(state);
                this.staleStates.add(state);
                break;
            }
            case 0: 
            case 7: {
                log.debug("Item " + state.getName() + " changed status from " + Status.getName(previousStatus) + " to " + Status.getName(state.getStatus()) + ".");
                break;
            }
            default: {
                log.error("ItemState " + state.getName() + " has invalid status: " + state.getStatus());
            }
        }
    }

    @Override
    public void created(ItemState state) {
        if (state.getStatus() == 4) {
            this.addedStates.add(state);
        }
    }
}

