/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRevision
implements InstanceRevision {
    private static final Logger log = LoggerFactory.getLogger(FileRevision.class);
    protected final RandomAccessFile raf;
    protected final boolean sync;
    protected long value;
    protected boolean closed;

    public FileRevision(File file, boolean sync) throws JournalException {
        this.sync = sync;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.raf = new RandomAccessFile(file, "rw");
            if (this.raf.length() == 0L) {
                this.set(0L);
            }
        }
        catch (IOException e) {
            String msg = "I/O error while attempting to create new file '" + file + "'.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public synchronized long get() throws JournalException {
        try {
            if (this.closed) {
                throw new JournalException("Revision file closed.");
            }
            this.raf.seek(0L);
            this.value = this.raf.readLong();
            return this.value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", e);
        }
    }

    @Override
    public synchronized void set(long value) throws JournalException {
        try {
            if (this.closed) {
                throw new JournalException("Revision file closed.");
            }
            this.raf.seek(0L);
            this.raf.writeLong(value);
            if (this.sync) {
                this.raf.getFD().sync();
            }
            this.value = value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.raf.close();
            this.closed = true;
        }
        catch (IOException e) {
            log.warn("I/O error closing revision file.", e);
        }
    }
}

