/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesNumberMetricsSet;

public class ActiveLoadPendingQueue {
    private final Set<String> pendingFileSet = new HashSet<String>();
    private final Queue<ActiveLoadEntry> pendingFileQueue = new ConcurrentLinkedQueue<ActiveLoadEntry>();
    private final Set<String> loadingFileSet = new HashSet<String>();

    public synchronized boolean enqueue(String file, String pendingDir, boolean isGeneratedByPipe) {
        if (!this.loadingFileSet.contains(file) && this.pendingFileSet.add(file)) {
            this.pendingFileQueue.offer(new ActiveLoadEntry(file, pendingDir, isGeneratedByPipe));
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseQueuingFileCounter(1L);
            return true;
        }
        return false;
    }

    public synchronized ActiveLoadEntry dequeueFromPending() {
        ActiveLoadEntry entry = this.pendingFileQueue.poll();
        if (entry != null) {
            this.pendingFileSet.remove(entry.getFile());
            this.loadingFileSet.add(entry.getFile());
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseLoadingFileCounter(1L);
            ActiveLoadingFilesNumberMetricsSet.getInstance().increaseQueuingFileCounter(-1L);
        }
        return entry;
    }

    public synchronized void removeFromLoading(String file) {
        this.loadingFileSet.remove(file);
        ActiveLoadingFilesNumberMetricsSet.getInstance().increaseLoadingFileCounter(-1L);
    }

    public synchronized boolean isFilePendingOrLoading(String file) {
        return this.loadingFileSet.contains(file) || this.pendingFileSet.contains(file);
    }

    public int size() {
        return this.pendingFileQueue.size() + this.loadingFileSet.size();
    }

    public boolean isEmpty() {
        return this.pendingFileQueue.isEmpty() && this.loadingFileSet.isEmpty();
    }

    public static class ActiveLoadEntry {
        private final String file;
        private final String pendingDir;
        private final boolean isGeneratedByPipe;

        public ActiveLoadEntry(String file, String pendingDir, boolean isGeneratedByPipe) {
            this.file = file;
            this.pendingDir = pendingDir;
            this.isGeneratedByPipe = isGeneratedByPipe;
        }

        public String getFile() {
            return this.file;
        }

        public String getPendingDir() {
            return this.pendingDir;
        }

        public boolean isGeneratedByPipe() {
            return this.isGeneratedByPipe;
        }
    }
}

