/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.versioned;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

public abstract class VersionedSerializer<T> {
    private static final int MAGIC = 1136586496;

    protected byte getProtocolVersion() {
        return 1;
    }

    protected abstract void writeExternalData(T var1, IgniteDataOutput var2) throws IOException;

    public final void writeExternal(T object, IgniteDataOutput out) throws IOException {
        int hdr = 1136586496 + Byte.toUnsignedInt(this.getProtocolVersion());
        out.writeInt(hdr);
        this.writeExternalData(object, out);
    }

    protected abstract T readExternalData(byte var1, IgniteDataInput var2) throws IOException;

    public final T readExternal(IgniteDataInput in) throws IOException {
        int hdr = in.readInt();
        if ((hdr & 0x43BEEF00) != 1136586496) {
            throw new IOException("Unexpected serialized object header [actual=" + Integer.toHexString(hdr) + ", expected=" + Integer.toHexString(1136586496) + "]");
        }
        byte ver = (byte)(hdr & 0xFF);
        return this.readExternalData(ver, in);
    }

    protected static void writeNullableString(@Nullable String str, IgniteDataOutput out) throws IOException {
        out.writeVarInt(str == null ? -1L : (long)str.length());
        if (str != null) {
            out.writeByteArray(str.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Nullable
    protected static String readNullableString(IgniteDataInput in) throws IOException {
        int lengthOrMinusOne = in.readVarIntAsInt();
        if (lengthOrMinusOne == -1) {
            return null;
        }
        return new String(in.readByteArray(lengthOrMinusOne), StandardCharsets.UTF_8);
    }

    protected static void writeStringSet(Set<String> strings, IgniteDataOutput out) throws IOException {
        out.writeVarInt(strings.size());
        for (String str : strings) {
            out.writeUTF(str);
        }
    }

    protected static Set<String> readStringSet(IgniteDataInput in) throws IOException {
        int size = in.readVarIntAsInt();
        HashSet<String> result = new HashSet<String>(IgniteUtils.capacity(size));
        for (int i = 0; i < size; ++i) {
            result.add(in.readUTF());
        }
        return result;
    }

    protected static void writeVarIntSet(Set<Integer> varIntSet, IgniteDataOutput out) throws IOException {
        out.writeVarInt(varIntSet.size());
        for (int partitionId : varIntSet) {
            out.writeVarInt(partitionId);
        }
    }

    protected static Set<Integer> readVarIntSet(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashSet<Integer> set = new HashSet<Integer>(IgniteUtils.capacity(length));
        for (int i = 0; i < length; ++i) {
            set.add(in.readVarIntAsInt());
        }
        return set;
    }
}

