/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.connect;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.config.CliConfigKeys;
import org.apache.ignite3.internal.cli.config.StateConfigProvider;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.internal.cli.event.EventPublisher;
import org.apache.ignite3.internal.cli.event.Events;
import org.apache.ignite3.rest.client.api.ClusterManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class ConnectSuccessCall {
    private final StateConfigProvider stateConfigProvider;
    private final EventPublisher eventPublisher;
    private final ApiClientFactory clientFactory;

    public ConnectSuccessCall(StateConfigProvider stateConfigProvider, EventPublisher eventPublisher, ApiClientFactory clientFactory) {
        this.stateConfigProvider = stateConfigProvider;
        this.eventPublisher = eventPublisher;
        this.clientFactory = clientFactory;
    }

    public CallOutput<String> execute(SessionInfo sessionInfo, boolean checkClusterInit) {
        this.stateConfigProvider.get().setProperty(CliConfigKeys.LAST_CONNECTED_URL.value(), sessionInfo.nodeUrl());
        this.eventPublisher.publish(Events.connect(sessionInfo));
        MessageUiComponent.MessageComponentBuilder builder = MessageUiComponent.builder().message("Connected to %s", UiElements.url(sessionInfo.nodeUrl()));
        if (checkClusterInit) {
            this.checkClusterInit(sessionInfo, builder);
        }
        return DefaultCallOutput.success(builder.build().render());
    }

    private void checkClusterInit(SessionInfo sessionInfo, MessageUiComponent.MessageComponentBuilder builder) {
        block2: {
            try {
                new ClusterManagementApi(this.clientFactory.getClient(sessionInfo.nodeUrl())).clusterState();
            }
            catch (ApiException e) {
                if (e.getCode() != 409) break block2;
                builder.hint("The cluster is not initialized. Run %s command to initialize it.", UiElements.command("cluster init"));
            }
        }
    }
}

