/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimestampWithTimeZoneString
implements Comparable<TimestampWithTimeZoneString> {
    final TimestampString localDateTime;
    final TimeZone timeZone;
    final String v;
    private final DateTimeUtils.PrecisionTime pt;
    private static final ThreadLocal<@Nullable SimpleDateFormat> TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> DateTimeStringUtils.getDateFormatter("yyyy-MM-dd HH:mm:ss"));

    public TimestampWithTimeZoneString(TimestampString localDateTime, TimeZone timeZone) {
        this.localDateTime = localDateTime;
        this.timeZone = timeZone;
        this.v = localDateTime.toString() + " " + timeZone.getID();
        this.pt = TimestampWithTimeZoneString.parseDateTime(localDateTime.toString(), this.timeZone);
    }

    public TimestampWithTimeZoneString(String v) {
        int pos = v.indexOf(32, "yyyy-MM-dd".length() + 1);
        if (pos == -1) {
            throw Static.RESOURCE.illegalLiteral("TIMESTAMP WITH LOCAL TIME ZONE", v, Static.RESOURCE.badFormat("yyyy-MM-dd HH:mm:ss").str()).ex();
        }
        String tsStr = v.substring(0, pos);
        this.localDateTime = new TimestampString(tsStr);
        String timeZoneString = v.substring(v.indexOf(32, "yyyy-MM-dd".length() + 1) + 1);
        Preconditions.checkArgument((boolean)DateTimeStringUtils.isValidTimeZone(timeZoneString));
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.v = v;
        this.pt = TimestampWithTimeZoneString.parseDateTime(tsStr, this.timeZone);
    }

    public TimestampWithTimeZoneString(int year, int month, int day, int h, int m, int s, String timeZone) {
        this(DateTimeStringUtils.ymdhms(new StringBuilder(), year, month, day, h, m, s).toString() + " " + timeZone);
    }

    public TimestampWithTimeZoneString withMillis(int millis) {
        Preconditions.checkArgument((millis >= 0 && millis < 1000 ? 1 : 0) != 0);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimestampWithTimeZoneString withNanos(int nanos) {
        Preconditions.checkArgument((nanos >= 0 && nanos < 1000000000 ? 1 : 0) != 0);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimestampWithTimeZoneString withFraction(String fraction) {
        return new TimestampWithTimeZoneString(this.localDateTime.withFraction(fraction), this.timeZone);
    }

    public static TimestampWithTimeZoneString fromCalendarFields(Calendar calendar) {
        TimestampString ts = TimestampString.fromCalendarFields(calendar);
        return new TimestampWithTimeZoneString(ts, calendar.getTimeZone());
    }

    public TimestampWithTimeZoneString withTimeZone(TimeZone timeZone) {
        if (this.timeZone.equals(timeZone)) {
            return this;
        }
        String fraction = this.pt.getFraction();
        this.pt.getCalendar().setTimeZone(timeZone);
        if (!fraction.isEmpty()) {
            return new TimestampWithTimeZoneString(this.pt.getCalendar().get(1), this.pt.getCalendar().get(2) + 1, this.pt.getCalendar().get(5), this.pt.getCalendar().get(11), this.pt.getCalendar().get(12), this.pt.getCalendar().get(13), timeZone.getID()).withFraction(fraction);
        }
        return new TimestampWithTimeZoneString(this.pt.getCalendar().get(1), this.pt.getCalendar().get(2) + 1, this.pt.getCalendar().get(5), this.pt.getCalendar().get(11), this.pt.getCalendar().get(12), this.pt.getCalendar().get(13), timeZone.getID());
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof TimestampWithTimeZoneString && ((TimestampWithTimeZoneString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimestampWithTimeZoneString o) {
        return this.v.compareTo(o.v);
    }

    public TimestampWithTimeZoneString round(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        return new TimestampWithTimeZoneString(this.localDateTime.round(precision), this.timeZone);
    }

    public static TimestampWithTimeZoneString fromMillisSinceEpoch(long millis) {
        return new TimestampWithTimeZoneString(DateTimeUtils.unixTimestampToString((long)millis) + " " + DateTimeUtils.UTC_ZONE.getID()).withMillis((int)Math.floorMod(millis, 1000L));
    }

    public String toString(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        return this.localDateTime.toString(precision) + " " + this.timeZone.getID();
    }

    public DateString getLocalDateString() {
        return new DateString(this.localDateTime.toString().substring(0, 10));
    }

    public TimeString getLocalTimeString() {
        return new TimeString(this.localDateTime.toString().substring(11));
    }

    public TimestampString getLocalTimestampString() {
        return this.localDateTime;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private static DateTimeUtils.PrecisionTime parseDateTime(String tsStr, TimeZone timeZone) {
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral((String)tsStr, (DateFormat)Objects.requireNonNull(TIMESTAMP_FORMAT.get()), (TimeZone)timeZone, (int)-1);
        if (pt == null) {
            throw Static.RESOURCE.illegalLiteral("TIMESTAMP WITH LOCAL TIME ZONE", tsStr, Static.RESOURCE.badFormat("yyyy-MM-dd HH:mm:ss").str()).ex();
        }
        return pt;
    }
}

