/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.util.CollectionUtils;

public class LimitNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final long offset;
    private final long fetch;
    private final boolean fetchUndefined;
    private long rowsProcessed;
    private int waiting;
    private int requested;

    public LimitNode(ExecutionContext<RowT> ctx, long offset, long fetch) {
        super(ctx);
        this.offset = offset;
        this.fetchUndefined = fetch == -1L;
        this.fetch = fetch == -1L ? 0L : fetch;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        if (!this.hasMoreData()) {
            this.end();
            return;
        }
        assert (this.requested == 0) : this.requested;
        this.requested = rowsCnt;
        if (this.fetch > 0L) {
            long remain = IgniteMath.addExact(this.fetch, this.offset) - this.rowsProcessed;
            rowsCnt = remain > (long)rowsCnt ? rowsCnt : (int)remain;
        }
        this.waiting = rowsCnt;
        this.checkState();
        this.source().request(rowsCnt);
    }

    @Override
    public void push(RowT row) throws Exception {
        if (this.waiting == -1) {
            return;
        }
        --this.waiting;
        if (this.rowsProcessed >= this.offset && this.hasMoreData()) {
            --this.requested;
            this.downstream().push(row);
        }
        ++this.rowsProcessed;
        if (!this.hasMoreData() && this.requested > 0) {
            this.end();
        }
        if (this.waiting == 0 && this.requested > 0) {
            this.waiting = this.requested;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        if (this.waiting == -1) {
            return;
        }
        assert (this.downstream() != null);
        this.waiting = -1;
        this.downstream().end();
    }

    @Override
    protected void rewindInternal() {
        this.waiting = 0;
        this.requested = 0;
        this.rowsProcessed = 0L;
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting).app(", fetch=").app(this.fetch).app(", offset=").app(this.offset).app(", rowsProcessed=").app(this.rowsProcessed);
    }

    private boolean hasMoreData() {
        return this.fetchUndefined || this.rowsProcessed < this.fetch + this.offset;
    }
}

