/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.service;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite.raft.jraft.storage.logit.storage.db.AbstractDB;
import org.apache.ignite.raft.jraft.storage.logit.storage.factory.LogStoreFactory;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.AbstractFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileType;
import org.apache.ignite.raft.jraft.storage.logit.util.concurrent.ShutdownAbleThread;
import org.apache.ignite.raft.jraft.util.ArrayDeque;
import org.apache.ignite.raft.jraft.util.OnlyForTest;

public class AllocateFileService
extends ShutdownAbleThread {
    private final FileType fileType;
    private final String storePath;
    private final StoreOptions storeOptions;
    private final LogStoreFactory logStoreFactory;
    private final ArrayDeque<AllocatedResult> blankFiles = new ArrayDeque();
    private final AtomicLong nextFileSequence = new AtomicLong(0L);
    private final Lock allocateLock = new ReentrantLock();
    private final Condition fullCond = this.allocateLock.newCondition();
    private final Condition emptyCond = this.allocateLock.newCondition();

    public AllocateFileService(AbstractDB abstractDB, LogStoreFactory logStoreFactory) {
        this.fileType = abstractDB.getDBFileType();
        this.storePath = abstractDB.getStorePath();
        this.storeOptions = logStoreFactory.getStoreOptions();
        this.logStoreFactory = logStoreFactory;
    }

    @OnlyForTest
    public AllocateFileService(FileType fileType, String storePath, LogStoreFactory logStoreFactory) {
        this.fileType = fileType;
        this.storePath = storePath;
        this.logStoreFactory = logStoreFactory;
        this.storeOptions = logStoreFactory.getStoreOptions();
    }

    @Override
    public void run() {
        try {
            while (!this.isStopped()) {
                this.doAllocateFileInLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.onShutdown();
    }

    @Override
    public void onShutdown() {
        for (AllocatedResult result : this.blankFiles) {
            if (result.abstractFile == null) continue;
            result.abstractFile.shutdown(5000L, false);
        }
    }

    private AbstractFile allocateNewAbstractFile() {
        String newFilePath = this.getNewFilePath();
        AbstractFile file = this.logStoreFactory.newFile(this.fileType, newFilePath);
        if (this.storeOptions.isEnableWarmUpFile()) {
            file.warmupFile();
        }
        return file;
    }

    private void doAllocateFile0() {
        AbstractFile abstractFile = this.allocateNewAbstractFile();
        this.blankFiles.add(new AllocatedResult(abstractFile));
    }

    private void doAllocateFileInLock() throws InterruptedException {
        this.allocateLock.lock();
        try {
            while (this.blankFiles.size() >= this.storeOptions.getPreAllocateFileCount()) {
                this.fullCond.await();
            }
            this.doAllocateFile0();
            this.emptyCond.signal();
        }
        finally {
            this.allocateLock.unlock();
        }
    }

    public AbstractFile takeEmptyFile() throws Exception {
        this.allocateLock.lock();
        try {
            while (this.blankFiles.isEmpty()) {
                this.emptyCond.await();
            }
            AllocatedResult result = this.blankFiles.pollFirst();
            this.fullCond.signal();
            AbstractFile abstractFile = result.abstractFile;
            return abstractFile;
        }
        finally {
            this.allocateLock.unlock();
        }
    }

    public int getAllocatedFileCount() {
        return this.blankFiles.size();
    }

    private String getNewFilePath() {
        return this.storePath + File.separator + String.format("%019d", this.nextFileSequence.getAndIncrement()) + this.fileType.getFileSuffix();
    }

    public void setNextFileSequence(long sequence) {
        this.nextFileSequence.set(sequence);
    }

    public void addBlankAbstractFiles(List<AbstractFile> blankFiles) {
        for (AbstractFile blankFile : blankFiles) {
            this.blankFiles.add(new AllocatedResult(blankFile));
        }
    }

    public static class AllocatedResult {
        AbstractFile abstractFile;

        public AllocatedResult(AbstractFile abstractFile) {
            this.abstractFile = abstractFile;
        }
    }
}

