/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.replacement;

import org.apache.ignite.internal.util.GridUnsafe;

public class ClockPageReplacementFlags {
    private final int pagesCnt;
    private int curIdx;
    private final long flagsPtr;

    public ClockPageReplacementFlags(int totalPagesCnt, long memPtr) {
        this.pagesCnt = totalPagesCnt;
        this.flagsPtr = memPtr;
        GridUnsafe.zeroMemory((long)this.flagsPtr, (long)(totalPagesCnt + 7 >> 3));
    }

    public int poll() {
        while (true) {
            if (this.curIdx >= this.pagesCnt) {
                this.curIdx = 0;
            }
            long ptr = this.getPointer(this.curIdx);
            long flags = GridUnsafe.getLong((long)ptr);
            if ((this.curIdx & 0x3F) == 0 && flags == -1L) {
                GridUnsafe.putLong((long)ptr, (long)0L);
                this.curIdx += 64;
                continue;
            }
            long mask = -1L << this.curIdx;
            int bitIdx = Long.numberOfTrailingZeros((flags ^ 0xFFFFFFFFFFFFFFFFL) & mask);
            if (bitIdx == 64) {
                GridUnsafe.putLong((long)ptr, (long)(flags & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
                this.curIdx = (this.curIdx & 0xFFFFFFC0) + 64;
                continue;
            }
            GridUnsafe.putLong((long)ptr, (long)(flags & ((mask &= -1L << bitIdx ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL)));
            this.curIdx = (this.curIdx & 0xFFFFFFC0) + bitIdx + 1;
            if (this.curIdx <= this.pagesCnt) break;
        }
        return this.curIdx - 1;
    }

    private long getPointer(int pageIdx) {
        return this.flagsPtr + ((long)(pageIdx >> 3) & 0xFFFFFFFFFFFFFFF8L);
    }

    boolean getFlag(int pageIdx) {
        long flags = GridUnsafe.getLong((long)this.getPointer(pageIdx));
        return (flags & 1L << pageIdx) != 0L;
    }

    public void clearFlag(int pageIdx) {
        long newFlags;
        long oldFlags;
        long ptr = this.getPointer(pageIdx);
        long mask = 1L << pageIdx ^ 0xFFFFFFFFFFFFFFFFL;
        do {
            if ((oldFlags = GridUnsafe.getLong((long)ptr)) != (newFlags = oldFlags & mask)) continue;
            return;
        } while (!GridUnsafe.compareAndSwapLong(null, (long)ptr, (long)oldFlags, (long)newFlags));
    }

    public void setFlag(int pageIdx) {
        long newFlags;
        long oldFlags;
        long ptr = this.getPointer(pageIdx);
        long mask = 1L << pageIdx;
        do {
            if ((oldFlags = GridUnsafe.getLong((long)ptr)) != (newFlags = oldFlags | mask)) continue;
            return;
        } while (!GridUnsafe.compareAndSwapLong(null, (long)ptr, (long)oldFlags, (long)newFlags));
    }

    public static long requiredMemory(int pagesCnt) {
        return (long)((pagesCnt + 63) / 8) & 0xFFFFFFFFFFFFFFF8L;
    }
}

