/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.time.ZoneId;
import java.util.Set;
import org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.jetbrains.annotations.Nullable;

public class SqlProperties {
    private long queryTimeout;
    private Set<SqlQueryType> allowedQueryTypes = SqlQueryType.ALL;
    private boolean allowMultiStatement = true;
    private String defaultSchema = SqlCommon.DEFAULT_SCHEMA_NAME;
    private ZoneId timeZoneId = SqlCommon.DEFAULT_TIME_ZONE_ID;
    @Nullable
    private String userName;

    public SqlProperties() {
    }

    public SqlProperties(SqlProperties other) {
        this.queryTimeout = other.queryTimeout;
        this.allowedQueryTypes = other.allowedQueryTypes;
        this.defaultSchema = other.defaultSchema;
        this.timeZoneId = other.timeZoneId;
        this.userName = other.userName;
        this.allowMultiStatement = other.allowMultiStatement;
    }

    public SqlProperties queryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public long queryTimeout() {
        return this.queryTimeout;
    }

    public SqlProperties allowedQueryTypes(Set<SqlQueryType> allowedQueryTypes) {
        this.allowedQueryTypes = allowedQueryTypes;
        return this;
    }

    public Set<SqlQueryType> allowedQueryTypes() {
        return this.allowedQueryTypes;
    }

    public SqlProperties defaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    public SqlProperties timeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public ZoneId timeZoneId() {
        return this.timeZoneId;
    }

    public SqlProperties userName(@Nullable String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    public String userName() {
        return this.userName;
    }

    public SqlProperties allowMultiStatement(boolean allowMultiStatement) {
        this.allowMultiStatement = allowMultiStatement;
        return this;
    }

    public boolean allowMultiStatement() {
        return this.allowMultiStatement;
    }
}

