/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.index;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;

public class StorageSortedIndexDescriptor
implements StorageIndexDescriptor {
    private final int id;
    @IgniteToStringInclude
    private final List<StorageSortedIndexColumnDescriptor> columns;
    private final BinaryTupleSchema binaryTupleSchema;
    private final boolean mustBeBuilt;

    public StorageSortedIndexDescriptor(CatalogTableDescriptor table, CatalogSortedIndexDescriptor index) {
        this(index.id(), StorageSortedIndexDescriptor.extractIndexColumnsConfiguration(table, index), !index.isCreatedWithTable());
    }

    public StorageSortedIndexDescriptor(int indexId, List<StorageSortedIndexColumnDescriptor> columnDescriptors, boolean mustBeBuilt) {
        this.id = indexId;
        this.columns = List.copyOf(columnDescriptors);
        this.binaryTupleSchema = StorageSortedIndexDescriptor.createSchema(this.columns);
        this.mustBeBuilt = mustBeBuilt;
    }

    private static BinaryTupleSchema createSchema(List<StorageSortedIndexColumnDescriptor> columns) {
        BinaryTupleSchema.Element[] elements = (BinaryTupleSchema.Element[])columns.stream().map(columnDescriptor -> new BinaryTupleSchema.Element(columnDescriptor.type(), columnDescriptor.nullable())).toArray(BinaryTupleSchema.Element[]::new);
        return BinaryTupleSchema.create((BinaryTupleSchema.Element[])elements);
    }

    @Override
    public int id() {
        return this.id;
    }

    public List<StorageSortedIndexColumnDescriptor> columns() {
        return this.columns;
    }

    @Override
    public boolean mustBeBuilt() {
        return this.mustBeBuilt;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public BinaryTupleSchema binaryTupleSchema() {
        return this.binaryTupleSchema;
    }

    private static List<StorageSortedIndexColumnDescriptor> extractIndexColumnsConfiguration(CatalogTableDescriptor table, CatalogSortedIndexDescriptor index) {
        assert (table.id() == index.tableId()) : "indexId=" + index.id() + ", tableId=" + table.id() + ", indexTableId=" + index.tableId();
        return index.columns().stream().map(columnDescriptor -> {
            String columnName = columnDescriptor.name();
            CatalogTableColumnDescriptor column = table.column(columnName);
            assert (column != null) : "indexId=" + index.id() + ", columnName=" + columnName;
            CatalogColumnCollation collation = columnDescriptor.collation();
            return new StorageSortedIndexColumnDescriptor(columnName, StorageIndexDescriptor.getNativeType(column), column.nullable(), collation.asc(), collation.nullsFirst());
        }).collect(Collectors.toList());
    }

    public static class StorageSortedIndexColumnDescriptor
    implements StorageIndexDescriptor.StorageColumnDescriptor {
        private final String name;
        @IgniteToStringInclude
        private final NativeType type;
        private final boolean nullable;
        private final boolean asc;
        private final boolean nullsFirst;

        public StorageSortedIndexColumnDescriptor(String name, NativeType type, boolean nullable, boolean asc, boolean nullsFirst) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.asc = asc;
            this.nullsFirst = nullsFirst;
        }

        @Override
        @Deprecated
        public String name() {
            return this.name;
        }

        @Override
        public NativeType type() {
            return this.type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public boolean asc() {
            return this.asc;
        }

        public boolean nullsFirst() {
            return this.nullsFirst;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

