/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.ignite.internal.distributionzones.DataNodesHistoryEntry;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.NodeWithAttributesSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class DataNodesHistory {
    @IgniteToStringInclude
    private final NavigableMap<HybridTimestamp, Set<NodeWithAttributes>> history;

    public DataNodesHistory() {
        this(new TreeMap<HybridTimestamp, Set<NodeWithAttributes>>());
    }

    private DataNodesHistory(NavigableMap<HybridTimestamp, Set<NodeWithAttributes>> history) {
        this.history = history;
    }

    public DataNodesHistory addHistoryEntry(HybridTimestamp timestamp, Set<NodeWithAttributes> nodes) {
        DataNodesHistory dataNodesHistory = new DataNodesHistory(new TreeMap<HybridTimestamp, Set<NodeWithAttributes>>((SortedMap<HybridTimestamp, Set<NodeWithAttributes>>)this.history));
        dataNodesHistory.history.put(timestamp, nodes);
        return dataNodesHistory;
    }

    public boolean entryIsPresentAtExactTimestamp(HybridTimestamp timestamp) {
        return this.history.containsKey(timestamp);
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public DataNodesHistoryEntry dataNodesForTimestamp(HybridTimestamp timestamp) {
        Map.Entry<HybridTimestamp, Set<NodeWithAttributes>> entry = this.history.floorEntry(timestamp);
        if (entry == null) {
            return new DataNodesHistoryEntry(HybridTimestamp.MIN_VALUE, Collections.emptySet());
        }
        return new DataNodesHistoryEntry(entry.getKey(), entry.getValue());
    }

    public String toString() {
        return S.toString(DataNodesHistory.class, (Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNodesHistory history1 = (DataNodesHistory)o;
        return Objects.equals(this.history, history1.history);
    }

    public int hashCode() {
        return Objects.hashCode(this.history);
    }

    public static class DataNodesHistorySerializer
    extends VersionedSerializer<DataNodesHistory> {
        private static final DataNodesHistorySerializer INSTANCE = new DataNodesHistorySerializer();

        protected void writeExternalData(DataNodesHistory object, IgniteDataOutput out) throws IOException {
            out.writeMap(object.history, (k, out0) -> out0.writeLong(k.longValue()), (v, out0) -> out0.writeCollection(new TreeSet(v), (arg_0, arg_1) -> ((NodeWithAttributesSerializer)NodeWithAttributesSerializer.INSTANCE).writeExternal(arg_0, arg_1)));
        }

        protected DataNodesHistory readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
            NavigableMap history = (NavigableMap)in.readMap(unused -> new TreeMap(), in0 -> HybridTimestamp.hybridTimestamp((long)in0.readLong()), in0 -> (Set)in0.readCollection(unused -> new TreeSet(), arg_0 -> ((NodeWithAttributesSerializer)NodeWithAttributesSerializer.INSTANCE).readExternal(arg_0)));
            return new DataNodesHistory(history);
        }

        public static byte[] serialize(DataNodesHistory dataNodesHistory) {
            return VersionedSerialization.toBytes((Object)dataNodesHistory, (VersionedSerializer)INSTANCE);
        }

        public static DataNodesHistory deserialize(byte[] bytes) {
            return (DataNodesHistory)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)INSTANCE);
        }
    }
}

