/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaImpl;

class PartitionSnapshotMetaSerializer
implements MessageSerializer<PartitionSnapshotMeta> {
    public static final PartitionSnapshotMetaSerializer INSTANCE = new PartitionSnapshotMetaSerializer();

    private PartitionSnapshotMetaSerializer() {
    }

    public boolean writeMessage(PartitionSnapshotMeta msg, MessageWriter writer) throws MessageMappingException {
        PartitionSnapshotMetaImpl message = (PartitionSnapshotMetaImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)13)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("cfgIndex", message.cfgIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("cfgTerm", message.cfgTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("lastIncludedIndex", message.lastIncludedIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeLong("lastIncludedTerm", message.lastIncludedTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeCollection("learnersList", message.learnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeLong("leaseStartTime", message.leaseStartTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeMap("nextRowIdToBuildByIndexId", message.nextRowIdToBuildByIndexId(), MessageCollectionItemType.INT, MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeCollection("oldLearnersList", message.oldLearnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeCollection("oldPeersList", message.oldPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeCollection("peersList", message.peersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                boolean written = writer.writeUuid("primaryReplicaNodeId", message.primaryReplicaNodeId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                boolean written = writer.writeString("primaryReplicaNodeName", message.primaryReplicaNodeName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                boolean written = writer.writeInt("requiredCatalogVersion", message.requiredCatalogVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

