/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite.internal.schema.marshaller.reflection.RecordMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.DataStreamer;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.PojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class RecordViewImpl<R>
extends AbstractTableView<R>
implements RecordView<R> {
    private final Mapper<R> mapper;
    private final Function<SchemaDescriptor, RecordMarshaller<R>> marshallerFactory;
    @Nullable
    private volatile RecordMarshaller<R> marsh;

    public RecordViewImpl(InternalTable tbl, SchemaRegistry schemaRegistry, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers, Mapper<R> mapper) {
        super(tbl, schemaVersions, schemaRegistry, sql, marshallers);
        this.mapper = mapper;
        this.marshallerFactory = schema -> new RecordMarshallerImpl(schema, marshallers, mapper);
    }

    public R get(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        return this.doOperation(tx, schemaVersion -> this.tbl.getAll(this.marshalKeys(keyRecs, schemaVersion), (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, false, schemaVersion, true)));
    }

    public boolean contains(@Nullable Transaction tx, R keyRec) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
        });
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> keyRows = this.marshalKeys(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.upsert(keyRow, (InternalTransaction)tx);
        });
    }

    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        return this.doOperation(tx, schemaVersion -> this.tbl.upsertAll(this.marshal(recs, schemaVersion), (InternalTransaction)tx));
    }

    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.getAndUpsert(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    public boolean insert(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.insert(keyRow, (InternalTransaction)tx);
        });
    }

    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(recs, schemaVersion);
            return this.tbl.insertAll(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, false, schemaVersion, false));
        });
    }

    public boolean replace(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx newRow = this.marshal(rec, schemaVersion);
            return this.tbl.replace(newRow, (InternalTransaction)tx);
        });
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx oldRow = this.marshal(oldRec, schemaVersion);
            BinaryRowEx newRow = this.marshal(newRec, schemaVersion);
            return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
        });
    }

    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return (R)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(rec, schemaVersion);
            return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.delete(row, (InternalTransaction)tx);
        });
    }

    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(keyRec, schemaVersion);
            return this.tbl.deleteExact(row, (InternalTransaction)tx);
        });
    }

    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return (R)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.getAndDelete(row, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshalKeys(keyRecs, schemaVersion);
            return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, true, schemaVersion, false));
        });
    }

    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(recs, schemaVersion);
            return this.tbl.deleteAllExact(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, true, schemaVersion, false));
        });
    }

    private RecordMarshaller<R> marshaller(int schemaVersion) throws MarshallerException {
        RecordMarshaller<R> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        try {
            SchemaDescriptor schema = this.rowConverter.registry().schema(schemaVersion);
            this.marsh = marsh = this.marshallerFactory.apply(schema);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
        return marsh;
    }

    private BinaryRowEx marshal(R rec, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(rec);
    }

    private Collection<BinaryRowEx> marshal(Collection<R> recs, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            Row row = marsh.marshal(Objects.requireNonNull(rec));
            rows.add((BinaryRowEx)row);
        }
        return rows;
    }

    private Collection<BinaryRowEx> marshal(Collection<R> recs, int schemaVersion, @Nullable BitSet deleted) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            boolean isDeleted = deleted != null && deleted.get(rows.size());
            Row row = isDeleted ? marsh.marshalKey(rec) : marsh.marshal(rec);
            rows.add((BinaryRowEx)row);
        }
        return rows;
    }

    private BinaryRowEx marshalKey(R rec, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        return marsh.marshalKey(rec);
    }

    private Collection<BinaryRowEx> marshalKeys(Collection<R> recs, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            Row row = marsh.marshalKey(Objects.requireNonNull(rec));
            rows.add((BinaryRowEx)row);
        }
        return rows;
    }

    @Nullable
    private R unmarshal(@Nullable BinaryRow binaryRow, int targetSchemaVersion) {
        if (binaryRow == null) {
            return null;
        }
        Row row = this.rowConverter.resolveRow(binaryRow, targetSchemaVersion);
        RecordMarshaller<R> marshaller = this.marshaller(row.schemaVersion());
        return (R)marshaller.unmarshal(row);
    }

    private List<R> unmarshal(Collection<BinaryRow> rows, boolean keyOnly, int targetSchemaVersion, boolean addNull) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        RecordMarshaller<R> marsh = this.marshaller(targetSchemaVersion);
        ArrayList<Object> recs = new ArrayList<Object>(rows.size());
        List<Row> resolvedRows = keyOnly ? this.rowConverter.resolveKeys(rows, targetSchemaVersion) : this.rowConverter.resolveRows(rows, targetSchemaVersion);
        for (Row row : resolvedRows) {
            if (row != null) {
                recs.add(marsh.unmarshal(row));
                continue;
            }
            if (!addNull) continue;
            recs.add(null);
        }
        return recs;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll(this.marshal(items, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    public <E, V, R1, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, R> keyFunc, Function<E, V> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options, @Nullable A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        StreamerBatchSender batchSender = (partitionId, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation(new TablePartitionId(this.tbl.tableId(), partitionId.intValue())).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (ClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    private PojoStreamerPartitionAwarenessProvider<R> streamerPartitioner() {
        return new PojoStreamerPartitionAwarenessProvider<R>(this.rowConverter.registry(), this.tbl.partitions(), this.marshaller(this.rowConverter.registry().lastKnownSchemaVersion()));
    }

    @Override
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        Marshaller marsh = this.marshallers.getRowMarshaller(marshallerSchema, this.mapper, false, true);
        List cols = schema.columns();
        return row -> marsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, RecordViewImpl.columnNames(cols))), null);
    }
}

