/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.compaction;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManagerImpl;
import org.apache.ignite.internal.catalog.compaction.CatalogManagerCompactionFacade;
import org.apache.ignite.internal.catalog.compaction.message.AvailablePartitionsMessage;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMessageGroup;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMessagesFactory;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMinimumTimesRequest;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMinimumTimesResponse;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionPrepareUpdateTxBeginTimeMessage;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceMinimumRequiredTimeProvider;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.UpdateMinimumActiveTxBeginTimeReplicaRequest;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.apache.ignite.internal.tx.ActiveLocalTxMinimumRequiredTimeProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CatalogCompactionRunner
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(CatalogCompactionRunner.class);
    private static final CatalogCompactionMessagesFactory COMPACTION_MESSAGES_FACTORY = new CatalogCompactionMessagesFactory();
    private static final PartitionReplicationMessagesFactory REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final long ANSWER_TIMEOUT = 10000L;
    private final CatalogManagerCompactionFacade catalogManagerFacade;
    private final MessagingService messagingService;
    private final LogicalTopologyService logicalTopologyService;
    private final PlacementDriver placementDriver;
    private final ClockService clockService;
    private final Executor executor;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final MinimumRequiredTimeCollectorService localMinTimeCollectorService;
    private final String localNodeName;
    private final ActiveLocalTxMinimumRequiredTimeProvider activeLocalTxMinimumRequiredTimeProvider;
    private final ReplicaService replicaService;
    private final SchemaSyncService schemaSyncService;
    private final TopologyService topologyService;
    private final RebalanceMinimumRequiredTimeProvider rebalanceMinimumRequiredTimeProvider;
    private CompletableFuture<Void> lastRunFuture = CompletableFutures.nullCompletedFuture();
    @Nullable
    private volatile String compactionCoordinatorNodeName;
    private volatile HybridTimestamp lowWatermark;
    private volatile UUID localNodeId;

    public CatalogCompactionRunner(String localNodeName, CatalogManagerImpl catalogManager, MessagingService messagingService, LogicalTopologyService logicalTopologyService, PlacementDriver placementDriver, ReplicaService replicaService, ClockService clockService, SchemaSyncService schemaSyncService, TopologyService topologyService, Executor executor, ActiveLocalTxMinimumRequiredTimeProvider activeLocalTxMinimumRequiredTimeProvider, MinimumRequiredTimeCollectorService minimumRequiredTimeCollectorService, RebalanceMinimumRequiredTimeProvider rebalanceMinimumRequiredTimeProvider) {
        this.localNodeName = localNodeName;
        this.messagingService = messagingService;
        this.logicalTopologyService = logicalTopologyService;
        this.catalogManagerFacade = new CatalogManagerCompactionFacade(catalogManager);
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.topologyService = topologyService;
        this.placementDriver = placementDriver;
        this.replicaService = replicaService;
        this.executor = executor;
        this.activeLocalTxMinimumRequiredTimeProvider = activeLocalTxMinimumRequiredTimeProvider;
        this.localMinTimeCollectorService = minimumRequiredTimeCollectorService;
        this.rebalanceMinimumRequiredTimeProvider = rebalanceMinimumRequiredTimeProvider;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.messagingService.addMessageHandler(CatalogCompactionMessageGroup.class, (NetworkMessageHandler)new CatalogCompactionMessageHandler());
        this.localNodeId = this.topologyService.localMember().id();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        return CompletableFutures.nullCompletedFuture();
    }

    public void updateCoordinator(ClusterNode newCoordinator) {
        this.compactionCoordinatorNodeName = newCoordinator.name();
        this.triggerCompaction(this.lowWatermark);
    }

    @TestOnly
    @Nullable
    public String coordinator() {
        return this.compactionCoordinatorNodeName;
    }

    public CompletableFuture<Boolean> onLowWatermarkChanged(HybridTimestamp newLowWatermark) {
        this.lowWatermark = newLowWatermark;
        this.triggerCompaction(newLowWatermark);
        return CompletableFutures.falseCompletedFuture();
    }

    @TestOnly
    synchronized CompletableFuture<Void> lastRunFuture() {
        return this.lastRunFuture;
    }

    void triggerCompaction(@Nullable HybridTimestamp lwm) {
        if (lwm == null || !this.localNodeName.equals(this.compactionCoordinatorNodeName)) {
            return;
        }
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CatalogCompactionRunner catalogCompactionRunner = this;
            synchronized (catalogCompactionRunner) {
                CompletableFuture<Void> fut = this.lastRunFuture;
                if (!fut.isDone()) {
                    LOG.info("Catalog compaction is already in progress, skipping [timestamp={}].", new Object[]{lwm.longValue()});
                    return;
                }
                this.lastRunFuture = this.startCompaction(lwm, this.logicalTopologyService.localLogicalTopology());
            }
        });
    }

    private LocalMinTime getMinLocalTime(HybridTimestamp lwm) {
        Map partitionStates = this.localMinTimeCollectorService.minTimestampPerPartition();
        long partitionMinTime = Long.MAX_VALUE;
        for (Map.Entry e : partitionStates.entrySet()) {
            Long state = (Long)e.getValue();
            if (state == 0L) {
                LOG.debug("Partition state is missing [partition={}].", new Object[]{e.getKey()});
                return LocalMinTime.NOT_AVAILABLE;
            }
            partitionMinTime = Math.min(partitionMinTime, state);
        }
        long rebalanceMinTime = this.rebalanceMinimumRequiredTimeProvider.minimumRequiredTime();
        long chosenMinTime = Math.min(Math.min(lwm.longValue(), partitionMinTime), rebalanceMinTime);
        LOG.debug("Minimum required time was chosen [partitionMinTime={}, rebalanceMinTime={}, lowWatermark={}, chosen={}].", new Object[]{partitionMinTime, rebalanceMinTime, lwm, chosenMinTime});
        Map<Integer, BitSet> tableBitSet = CatalogCompactionRunner.buildTablePartitions(partitionStates);
        return new LocalMinTime(chosenMinTime, tableBitSet);
    }

    private CompletableFuture<Void> startCompaction(HybridTimestamp lwm, LogicalTopologySnapshot topologySnapshot) {
        LOG.info("Catalog compaction started [lowWaterMark={}].", new Object[]{lwm});
        LocalMinTime localMinRequiredTime = this.getMinLocalTime(lwm);
        long localMinTime = localMinRequiredTime.time;
        Map<Integer, BitSet> localPartitions = localMinRequiredTime.availablePartitions;
        return this.determineGlobalMinimumRequiredTime(topologySnapshot.nodes(), localMinTime, localPartitions).thenComposeAsync(timeHolder -> {
            long minRequiredTime = timeHolder.minRequiredTime;
            long txMinRequiredTime = timeHolder.txMinRequiredTime;
            Map<String, Map<Integer, BitSet>> allPartitions = timeHolder.allPartitions;
            CompletableFuture<Boolean> catalogCompactionFut = this.tryCompactCatalog(minRequiredTime, topologySnapshot, lwm, allPartitions);
            LOG.debug("Propagate minimum required tx time to replicas [timestamp={}].", new Object[]{txMinRequiredTime});
            CompletionStage propagateToReplicasFut = this.propagateTimeToNodes(txMinRequiredTime, topologySnapshot.nodes()).whenComplete((ignore, ex) -> {
                if (ex != null) {
                    LOG.warn("Failed to propagate minimum required tx time to replicas.", ex);
                }
            });
            return CompletableFuture.allOf(new CompletableFuture[]{catalogCompactionFut, propagateToReplicasFut});
        }, this.executor);
    }

    @TestOnly
    CompletableFuture<TimeHolder> determineGlobalMinimumRequiredTime(Collection<? extends ClusterNode> nodes, long localMinimumRequiredTime) {
        return this.determineGlobalMinimumRequiredTime(nodes, localMinimumRequiredTime, Map.of());
    }

    private CompletableFuture<TimeHolder> determineGlobalMinimumRequiredTime(Collection<? extends ClusterNode> nodes, long localMinimumRequiredTime, Map<Integer, BitSet> localPartitions) {
        CatalogCompactionMinimumTimesRequest request = COMPACTION_MESSAGES_FACTORY.catalogCompactionMinimumTimesRequest().build();
        ArrayList<CompletionStage> responseFutures = new ArrayList<CompletionStage>(nodes.size() - 1);
        for (ClusterNode clusterNode : nodes) {
            if (this.localNodeName.equals(clusterNode.name())) continue;
            CompletionStage fut = ((CompletableFuture)this.messagingService.invoke(clusterNode, (NetworkMessage)request, 10000L).thenApply(CatalogCompactionMinimumTimesResponse.class::cast)).thenApply(r -> new Pair((Object)node.name(), r));
            responseFutures.add(fut);
        }
        return CompletableFuture.allOf(responseFutures.toArray(new CompletableFuture[0])).thenApply(ignore -> {
            long globalMinimumRequiredTime = localMinimumRequiredTime;
            long globalMinimumTxRequiredTime = this.activeLocalTxMinimumRequiredTimeProvider.minimumRequiredTime();
            HashMap<String, Map<Integer, BitSet>> allPartitions = new HashMap<String, Map<Integer, BitSet>>();
            allPartitions.put(this.localNodeName, localPartitions);
            for (CompletableFuture fut : responseFutures) {
                Pair p = (Pair)fut.join();
                String nodeId = (String)p.getFirst();
                CatalogCompactionMinimumTimesResponse response = (CatalogCompactionMinimumTimesResponse)p.getSecond();
                if (response.minimumRequiredTime() < globalMinimumRequiredTime) {
                    globalMinimumRequiredTime = response.minimumRequiredTime();
                }
                if (response.activeTxMinimumRequiredTime() < globalMinimumTxRequiredTime) {
                    globalMinimumTxRequiredTime = response.activeTxMinimumRequiredTime();
                }
                allPartitions.put(nodeId, CatalogCompactionRunner.availablePartitionListToMap(response.partitions()));
            }
            return new TimeHolder(globalMinimumRequiredTime, globalMinimumTxRequiredTime, allPartitions);
        });
    }

    CompletableFuture<Void> propagateTimeToNodes(long timestamp, Collection<? extends ClusterNode> nodes) {
        CatalogCompactionPrepareUpdateTxBeginTimeMessage request = COMPACTION_MESSAGES_FACTORY.catalogCompactionPrepareUpdateTxBeginTimeMessage().timestamp(timestamp).build();
        ArrayList<CompletableFuture> sendFutures = new ArrayList<CompletableFuture>(nodes.size());
        for (ClusterNode clusterNode : nodes) {
            sendFutures.add(this.messagingService.send(clusterNode, (NetworkMessage)request));
        }
        return CompletableFutures.allOf(sendFutures);
    }

    CompletableFuture<Void> propagateTimeToLocalReplicas(long txBeginTime) {
        HybridTimestamp nowTs = this.clockService.now();
        return this.schemaSyncService.waitForMetadataCompleteness(nowTs).thenComposeAsync(ignore -> {
            Int2IntMap tablesWithPartitions = this.catalogManagerFacade.collectTablesWithPartitionsBetween(txBeginTime, nowTs.longValue());
            ObjectIterator itr = tablesWithPartitions.int2IntEntrySet().iterator();
            return this.invokeOnLocalReplicas(txBeginTime, this.localNodeId, (ObjectIterator<Int2IntMap.Entry>)itr);
        }, this.executor);
    }

    private CompletableFuture<Boolean> tryCompactCatalog(long minRequiredTime, LogicalTopologySnapshot topologySnapshot, HybridTimestamp lwm, Map<String, Map<Integer, BitSet>> allPartitions) {
        Catalog catalog = this.catalogManagerFacade.catalogPriorToVersionAtTsNullable(minRequiredTime);
        if (catalog == null) {
            LOG.info("Catalog compaction skipped, nothing to compact [timestamp={}].", new Object[]{minRequiredTime});
            return CompletableFutures.falseCompletedFuture();
        }
        for (CatalogIndexDescriptor index : catalog.indexes()) {
            if (index.status() != CatalogIndexStatus.BUILDING && index.status() != CatalogIndexStatus.REGISTERED) continue;
            LOG.info("Catalog compaction aborted, index construction is taking place.", new Object[0]);
            return CompletableFutures.falseCompletedFuture();
        }
        return ((CompletableFuture)this.validatePartitions(catalog, lwm, allPartitions).thenCompose(result -> {
            if (!((Boolean)result.getFirst()).booleanValue()) {
                LOG.info("Catalog compaction aborted due to mismatching table partitions.", new Object[0]);
                return CompletableFutures.falseCompletedFuture();
            }
            Set requiredNodes = (Set)result.getSecond();
            List<String> missingNodes = CatalogCompactionRunner.missingNodes(requiredNodes, topologySnapshot.nodes());
            if (!missingNodes.isEmpty()) {
                LOG.info("Catalog compaction aborted due to missing cluster members [nodes={}].", new Object[]{missingNodes});
                return CompletableFutures.falseCompletedFuture();
            }
            return this.catalogManagerFacade.compactCatalog(catalog.version());
        })).whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.warn("Catalog compaction has failed [timestamp={}].", ex, new Object[]{minRequiredTime});
            } else if (res.booleanValue()) {
                LOG.info("Catalog compaction completed successfully [timestamp={}].", new Object[]{minRequiredTime});
            } else {
                LOG.info("Catalog compaction skipped [timestamp={}].", new Object[]{minRequiredTime});
            }
        });
    }

    private CompletableFuture<Pair<Boolean, Set<String>>> validatePartitions(Catalog catalog, HybridTimestamp lwm, Map<String, Map<Integer, BitSet>> allPartitions) {
        HybridTimestamp nowTs = this.clockService.now();
        ConcurrentHashMap requiredPartitionsPerNode = new ConcurrentHashMap();
        ConcurrentHashMap deletedTables = new ConcurrentHashMap();
        Catalog currentCatalog = this.catalogManagerFacade.catalogAtTsNullable(nowTs.longValue());
        assert (currentCatalog != null);
        return CompletableFutures.allOf((Collection)catalog.tables().stream().map(table -> this.collectRequiredNodes(catalog, (CatalogTableDescriptor)table, nowTs, requiredPartitionsPerNode, currentCatalog, deletedTables)).collect(Collectors.toList())).thenApply(ignore -> {
            Set requiredNodeNames = requiredPartitionsPerNode.keySet();
            for (Map.Entry entry : requiredPartitionsPerNode.entrySet()) {
                RequiredPartitions partitionsPerNode = (RequiredPartitions)entry.getValue();
                String nodeId = (String)entry.getKey();
                Map actualPartitions = (Map)allPartitions.get(nodeId);
                if (actualPartitions == null) {
                    return new Pair((Object)false, (Object)requiredNodeNames);
                }
                Map<Integer, BitSet> requiredPartitions = partitionsPerNode.data();
                if (!actualPartitions.keySet().containsAll(requiredPartitions.keySet())) {
                    return new Pair((Object)false, (Object)requiredNodeNames);
                }
                for (Map.Entry<Integer, BitSet> tableParts : requiredPartitions.entrySet()) {
                    BitSet actual = (BitSet)actualPartitions.get(tableParts.getKey());
                    BitSet expected = tableParts.getValue();
                    BitSet cmp = (BitSet)actual.clone();
                    cmp.and(expected);
                    if (cmp.equals(expected)) continue;
                    return new Pair((Object)false, (Object)requiredNodeNames);
                }
            }
            Catalog catalogAtLwm = this.catalogManagerFacade.catalogAtTsNullable(lwm.longValue());
            assert (catalogAtLwm != null);
            Iterator iterator = ((ConcurrentHashMap.KeySetView)deletedTables.keySet()).iterator();
            while (iterator.hasNext()) {
                int tableId = (Integer)iterator.next();
                if (catalogAtLwm.table(tableId) == null) continue;
                return new Pair((Object)false, (Object)requiredNodeNames);
            }
            return new Pair((Object)true, (Object)requiredNodeNames);
        });
    }

    private CompletableFuture<Void> collectRequiredNodes(Catalog catalog, CatalogTableDescriptor table, HybridTimestamp nowTs, ConcurrentHashMap<String, RequiredPartitions> requiredPartitionsPerNode, Catalog currentCatalog, ConcurrentHashMap<Integer, Boolean> deletedTables) {
        CatalogZoneDescriptor zone = catalog.zone(table.zoneId());
        assert (zone != null) : table.zoneId();
        int partitions = zone.partitions();
        ArrayList<TablePartitionId> replicationGroupIds = new ArrayList<TablePartitionId>(partitions);
        for (int p = 0; p < partitions; ++p) {
            replicationGroupIds.add(new TablePartitionId(table.id(), p));
        }
        return this.placementDriver.getAssignments(replicationGroupIds, nowTs).thenAccept(tokenizedAssignments -> {
            assert (tokenizedAssignments.size() == replicationGroupIds.size());
            for (int p = 0; p < partitions; ++p) {
                TokenizedAssignments assignment = (TokenizedAssignments)tokenizedAssignments.get(p);
                if (assignment == null) {
                    if (currentCatalog.table(table.id()) == null) {
                        deletedTables.put(table.id(), true);
                        continue;
                    }
                    throw new IllegalStateException("Cannot get assignments for table [group=" + String.valueOf(replicationGroupIds.get(p)) + "]");
                }
                int partitionId = p;
                assignment.nodes().forEach(a -> {
                    String nodeId = a.consistentId();
                    RequiredPartitions partitionsAtNode = requiredPartitionsPerNode.computeIfAbsent(nodeId, k -> new RequiredPartitions());
                    partitionsAtNode.update(table.id(), partitionId);
                });
            }
        });
    }

    private static List<String> missingNodes(Set<String> requiredNodes, Collection<LogicalNode> logicalTopologyNodes) {
        Set logicalNodeIds = logicalTopologyNodes.stream().map(ClusterNode::name).collect(Collectors.toSet());
        return requiredNodes.stream().filter(Predicate.not(logicalNodeIds::contains)).collect(Collectors.toList());
    }

    private CompletableFuture<Void> invokeOnLocalReplicas(long txBeginTime, UUID localNodeId, ObjectIterator<Int2IntMap.Entry> tabTtr) {
        if (!tabTtr.hasNext()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Int2IntMap.Entry tableWithPartitions = (Int2IntMap.Entry)tabTtr.next();
        int tableId = tableWithPartitions.getIntKey();
        int partitions = tableWithPartitions.getIntValue();
        ArrayList<CompletionStage> partFutures = new ArrayList<CompletionStage>(partitions);
        HybridTimestamp nowTs = this.clockService.now();
        for (int p = 0; p < partitions; ++p) {
            TablePartitionId tablePartitionId = new TablePartitionId(tableId, p);
            CompletionStage fut = this.placementDriver.getPrimaryReplica((ReplicationGroupId)tablePartitionId, nowTs).thenCompose(meta -> {
                if (meta == null || meta.getLeaseholderId() == null) {
                    return CompletableFutures.nullCompletedFuture();
                }
                if (!localNodeId.equals(meta.getLeaseholderId())) {
                    return CompletableFutures.nullCompletedFuture();
                }
                TablePartitionIdMessage partIdMessage = ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartitionId);
                UpdateMinimumActiveTxBeginTimeReplicaRequest msg = REPLICATION_MESSAGES_FACTORY.updateMinimumActiveTxBeginTimeReplicaRequest().groupId((ReplicationGroupIdMessage)partIdMessage).timestamp(txBeginTime).build();
                return this.replicaService.invoke(this.localNodeName, (ReplicaRequest)msg);
            });
            partFutures.add(fut);
        }
        return CompletableFutures.allOf(partFutures).thenComposeAsync(ignore -> this.invokeOnLocalReplicas(txBeginTime, localNodeId, tabTtr), this.executor);
    }

    private static Map<Integer, BitSet> buildTablePartitions(Map<TablePartitionId, @Nullable Long> tablePartitionMap) {
        HashMap<Integer, BitSet> tableIdBitSet = new HashMap<Integer, BitSet>();
        for (Map.Entry<TablePartitionId, Long> e : tablePartitionMap.entrySet()) {
            TablePartitionId tp = e.getKey();
            Long time = e.getValue();
            tableIdBitSet.compute(tp.tableId(), (k, v) -> {
                int partition = tp.partitionId();
                if (v == null) {
                    v = new BitSet();
                }
                if (time != null) {
                    v.set(partition);
                }
                return v;
            });
        }
        return tableIdBitSet;
    }

    private static List<AvailablePartitionsMessage> availablePartitionsMessages(Map<Integer, BitSet> availablePartitions) {
        return availablePartitions.entrySet().stream().map(e -> COMPACTION_MESSAGES_FACTORY.availablePartitionsMessage().tableId((Integer)e.getKey()).partitions((BitSet)e.getValue()).build()).collect(Collectors.toList());
    }

    private static Map<Integer, BitSet> availablePartitionListToMap(List<AvailablePartitionsMessage> availablePartitions) {
        return availablePartitions.stream().map(a -> Map.entry(a.tableId(), a.partitions())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private class CatalogCompactionMessageHandler
    implements NetworkMessageHandler {
        private CatalogCompactionMessageHandler() {
        }

        public void onReceived(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
            assert (message.groupType() == 14) : message.groupType();
            switch (message.messageType()) {
                case 0: {
                    assert (correlationId != null);
                    this.handleMinimumTimesRequest(sender, correlationId);
                    break;
                }
                case 2: {
                    this.handlePrepareToUpdateTimeOnReplicasMessage(message);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported message type: " + message.messageType());
                }
            }
        }

        private void handleMinimumTimesRequest(ClusterNode sender, Long correlationId) {
            HybridTimestamp lwm = CatalogCompactionRunner.this.lowWatermark;
            LocalMinTime minLocalTime = lwm != null ? CatalogCompactionRunner.this.getMinLocalTime(lwm) : LocalMinTime.NOT_AVAILABLE;
            long minRequiredTime = minLocalTime.time;
            Map<Integer, BitSet> availablePartitions = minLocalTime.availablePartitions;
            CatalogCompactionMinimumTimesResponse response = COMPACTION_MESSAGES_FACTORY.catalogCompactionMinimumTimesResponse().minimumRequiredTime(minRequiredTime).activeTxMinimumRequiredTime(CatalogCompactionRunner.this.activeLocalTxMinimumRequiredTimeProvider.minimumRequiredTime()).partitions(CatalogCompactionRunner.availablePartitionsMessages(availablePartitions)).build();
            CatalogCompactionRunner.this.messagingService.respond(sender, (NetworkMessage)response, correlationId.longValue());
        }

        private void handlePrepareToUpdateTimeOnReplicasMessage(NetworkMessage message) {
            long txBeginTime = ((CatalogCompactionPrepareUpdateTxBeginTimeMessage)message).timestamp();
            CatalogCompactionRunner.this.propagateTimeToLocalReplicas(txBeginTime).exceptionally(ex -> {
                LOG.warn("Failed to propagate minimum required time to replicas.", ex);
                return null;
            });
        }
    }

    private static class LocalMinTime {
        private static final LocalMinTime NOT_AVAILABLE = new LocalMinTime(HybridTimestamp.MIN_VALUE.longValue(), Collections.emptyMap());
        final long time;
        final Map<Integer, BitSet> availablePartitions;

        LocalMinTime(long time, Map<Integer, BitSet> availablePartitions) {
            this.time = time;
            this.availablePartitions = availablePartitions;
        }
    }

    private static class RequiredPartitions {
        final Map<Integer, BitSet> partitions = new HashMap<Integer, BitSet>();

        private RequiredPartitions() {
        }

        synchronized void update(int tableId, int p) {
            this.partitions.compute(tableId, (k, v) -> {
                if (v == null) {
                    v = new BitSet();
                }
                v.set(p);
                return v;
            });
        }

        synchronized Map<Integer, BitSet> data() {
            return this.partitions;
        }
    }

    static class TimeHolder {
        final long minRequiredTime;
        final long txMinRequiredTime;
        final Map<String, Map<Integer, BitSet>> allPartitions;

        private TimeHolder(long minRequiredTime, long txMinRequiredTime, Map<String, Map<Integer, BitSet>> allPartitions) {
            this.minRequiredTime = minRequiredTime;
            this.txMinRequiredTime = txMinRequiredTime;
            this.allPartitions = allPartitions;
        }
    }
}

