/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class VersionedUpdate
implements UpdateLogEvent {
    private final int version;
    private final long delayDurationMs;
    @IgniteToStringInclude
    private final List<UpdateEntry> entries;

    public VersionedUpdate(int version, long delayDurationMs, List<UpdateEntry> entries) {
        this.version = version;
        this.delayDurationMs = delayDurationMs;
        this.entries = List.copyOf((Collection)Objects.requireNonNull(entries, "entries"));
    }

    public int version() {
        return this.version;
    }

    public long delayDurationMs() {
        return this.delayDurationMs;
    }

    public List<UpdateEntry> entries() {
        return this.entries;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.VERSIONED_UPDATE.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedUpdate that = (VersionedUpdate)o;
        return this.version == that.version && this.entries.equals(that.entries);
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + this.entries.hashCode();
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public static class VersionedUpdateSerializer
    implements CatalogObjectSerializer<VersionedUpdate> {
        private final CatalogEntrySerializerProvider serializers;

        public VersionedUpdateSerializer(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public VersionedUpdate readFrom(IgniteDataInput input) throws IOException {
            int ver = input.readVarIntAsInt();
            long delayDurationMs = input.readVarInt();
            int size = input.readVarIntAsInt();
            ArrayList<UpdateEntry> entries = new ArrayList<UpdateEntry>(size);
            for (int i = 0; i < size; ++i) {
                short entryTypeId = (short)input.readVarIntAsInt();
                CatalogObjectSerializer<MarshallableEntry> serializer = this.serializers.get(entryTypeId);
                entries.add((UpdateEntry)serializer.readFrom(input));
            }
            return new VersionedUpdate(ver, delayDurationMs, entries);
        }

        @Override
        public void writeTo(VersionedUpdate update, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)update.version());
            output.writeVarInt(update.delayDurationMs());
            output.writeVarInt((long)update.entries().size());
            for (UpdateEntry entry : update.entries()) {
                output.writeVarInt((long)entry.typeId());
                this.serializers.get(entry.typeId()).writeTo(entry, output);
            }
        }
    }
}

