/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.task;

import java.util.Collection;
import java.util.Optional;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.lang.IgnitePredicate;

public class TaskExecutionOptions {
    private String name;
    private long timeout;
    private String execName;
    private Byte pool;
    private Collection<ClusterNode> projection;
    private IgnitePredicate<ClusterNode> projectionPredicate;
    private boolean isFailoverDisabled;
    private boolean isResultCacheDisabled;
    private boolean isSysTask;
    private boolean isPublicReq;

    private TaskExecutionOptions() {
    }

    private TaskExecutionOptions(TaskExecutionOptions other) {
        this.name = other.name;
        this.timeout = other.timeout;
        this.execName = other.execName;
        this.pool = other.pool;
        this.projection = other.projection;
        this.projectionPredicate = other.projectionPredicate;
        this.isFailoverDisabled = other.isFailoverDisabled;
        this.isResultCacheDisabled = other.isResultCacheDisabled;
        this.isSysTask = other.isSysTask;
        this.isPublicReq = other.isPublicReq;
    }

    public static TaskExecutionOptions options() {
        return new TaskExecutionOptions();
    }

    public static TaskExecutionOptions options(Collection<ClusterNode> projection) {
        return new TaskExecutionOptions().withProjection(projection);
    }

    public static TaskExecutionOptions options(TaskExecutionOptions other) {
        return new TaskExecutionOptions(other);
    }

    public long timeout() {
        return this.timeout;
    }

    public TaskExecutionOptions withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public TaskExecutionOptions withName(String name) {
        this.name = name;
        return this;
    }

    public Collection<ClusterNode> projection() {
        return this.projection;
    }

    public TaskExecutionOptions withProjection(Collection<ClusterNode> projection) {
        this.projection = projection;
        return this;
    }

    public IgnitePredicate<ClusterNode> projectionPredicate() {
        return this.projectionPredicate;
    }

    public TaskExecutionOptions withProjectionPredicate(IgnitePredicate<ClusterNode> projectionPredicate) {
        this.projectionPredicate = projectionPredicate;
        return this;
    }

    public String executor() {
        return this.execName;
    }

    public TaskExecutionOptions withExecutor(String execName) {
        this.execName = execName;
        return this;
    }

    public Optional<Byte> pool() {
        return Optional.ofNullable(this.pool);
    }

    public TaskExecutionOptions withPool(byte pool) {
        this.pool = pool;
        return this;
    }

    public boolean isFailoverDisabled() {
        return this.isFailoverDisabled;
    }

    public TaskExecutionOptions withFailoverDisabled() {
        this.isFailoverDisabled = true;
        return this;
    }

    public boolean isResultCacheDisabled() {
        return this.isResultCacheDisabled;
    }

    public TaskExecutionOptions withResultCacheDisabled() {
        this.isResultCacheDisabled = true;
        return this;
    }

    public boolean isSystemTask() {
        return this.isSysTask;
    }

    public TaskExecutionOptions asSystemTask() {
        this.isSysTask = true;
        return this;
    }

    public boolean isPublicRequest() {
        return this.isPublicReq;
    }

    public TaskExecutionOptions asPublicRequest() {
        this.isPublicReq = true;
        return this;
    }
}

