/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.reducer;

import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.query.reducer.CacheQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePage;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;

abstract class MergeSortCacheQueryReducer<R>
extends CacheQueryReducer<R> {
    private static final long serialVersionUID = 0L;
    private PriorityQueue<NodePage<R>> nodePages;
    private UUID pendingNodeId;

    protected MergeSortCacheQueryReducer(Map<UUID, NodePageStream<R>> pageStreams) {
        super(pageStreams);
    }

    protected abstract CompletableFuture<Comparator<NodePage<R>>> pageComparator();

    @Override
    public boolean hasNextX() throws IgniteCheckedException {
        if (this.nodePages == null) {
            this.nodePages = new PriorityQueue(this.pageStreams.size(), (Comparator)MergeSortCacheQueryReducer.get(this.pageComparator()));
            for (NodePageStream s : this.pageStreams.values()) {
                NodePage p = (NodePage)MergeSortCacheQueryReducer.get(s.headPage());
                if (p == null || !p.hasNext()) continue;
                this.nodePages.add(p);
            }
        }
        if (this.pendingNodeId != null) {
            NodePage p;
            NodePageStream stream = (NodePageStream)this.pageStreams.get(this.pendingNodeId);
            if (!stream.closed() && (p = (NodePage)MergeSortCacheQueryReducer.get(stream.headPage())) != null && p.hasNext()) {
                this.nodePages.add(p);
            }
            this.pendingNodeId = null;
        }
        return !this.nodePages.isEmpty();
    }

    @Override
    public R nextX() throws IgniteCheckedException {
        if (this.nodePages.isEmpty()) {
            throw new NoSuchElementException("No next element. Please, be sure to invoke hasNext() before next().");
        }
        NodePage<R> page = this.nodePages.poll();
        R o = page.next();
        if (page.hasNext()) {
            this.nodePages.offer(page);
        } else if (!((NodePageStream)this.pageStreams.get(page.nodeId())).closed()) {
            this.pendingNodeId = page.nodeId();
        }
        return o;
    }
}

