/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.wal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class ClusterNode
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private String consistentId;
    private Map<String, Object> attrs;
    @GridToStringInclude
    private Collection<String> addrs;
    @GridToStringInclude
    private Collection<String> hostNames;

    public ClusterNode() {
    }

    public ClusterNode(org.apache.ignite.cluster.ClusterNode node) {
        this.consistentId = String.valueOf(node.consistentId());
        this.addrs = node.addresses();
        this.hostNames = node.hostNames();
        this.attrs = node.attributes();
    }

    public String getConsistentId() {
        return this.consistentId;
    }

    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    public Collection<String> getAddresses() {
        return this.addrs;
    }

    public Collection<String> getHostNames() {
        return this.hostNames;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.consistentId);
        U.writeMap(out, this.attrs);
        U.writeCollection(out, this.hostNames);
        U.writeCollection(out, this.addrs);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.consistentId = U.readString(in);
        this.attrs = U.readMap(in);
        this.hostNames = U.readCollection(in);
        this.addrs = U.readCollection(in);
    }

    public String toString() {
        return S.toString(ClusterNode.class, this);
    }
}

