/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.check_indexes_inline_size;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;

@GridInternal
public class CheckIndexInlineSizesResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<UUID, Map<String, Integer>> nodeToIndexes = new HashMap<UUID, Map<String, Integer>>();

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.nodeToIndexes.size());
        for (UUID id : this.nodeToIndexes.keySet()) {
            U.writeUuid(out, id);
            U.writeMap(out, this.nodeToIndexes.get(id));
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            UUID id = U.readUuid(in);
            Map map = U.readMap(in);
            this.nodeToIndexes.put(id, map);
        }
    }

    public void addResult(UUID nodeId, Map<String, Integer> indexNameToInlineSize) {
        Map<String, Integer> prev = this.nodeToIndexes.put(nodeId, indexNameToInlineSize);
        assert (prev == null) : nodeId + " prev: " + prev + " cur: " + indexNameToInlineSize;
    }

    public void merge(CheckIndexInlineSizesResult res) {
        for (Map.Entry<UUID, Map<String, Integer>> entry : res.nodeToIndexes.entrySet()) {
            this.addResult(entry.getKey(), entry.getValue());
        }
    }

    public Map<UUID, Map<String, Integer>> inlineSizes() {
        return this.nodeToIndexes;
    }
}

