/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.impl.routing.PathPatternMatcher;
import org.apache.hc.core5.http.impl.routing.PathRoute;

final class UriPathRouter<P, T>
implements Function<String, T> {
    private final BiFunction<String, List<PathRoute<P, T>>, T> pathRouter;
    private final List<PathRoute<P, T>> routes;
    private static final PathPatternMatcher PATH_PATTERN_MATCHER = PathPatternMatcher.INSTANCE;

    UriPathRouter(Function<String, P> compiler, BiFunction<String, List<PathRoute<P, T>>, T> pathRouter, List<PathRoute<String, T>> routes) {
        this.pathRouter = pathRouter;
        this.routes = Collections.unmodifiableList(routes.stream().map(e -> new PathRoute(compiler.apply((String)e.pattern), e.handler)).collect(Collectors.toList()));
    }

    @Override
    public T apply(String path) {
        return this.pathRouter.apply(path, this.routes);
    }

    public String toString() {
        return this.routes.toString();
    }

    static <T> UriPathRouter<?, T> bestMatch(List<PathRoute<String, T>> routes) {
        return new UriPathRouter(Function.identity(), BestMatcher.getInstance(), routes);
    }

    static <T> UriPathRouter<?, T> ordered(List<PathRoute<String, T>> routes) {
        return new UriPathRouter(Function.identity(), OrderedMatcher.getInstance(), routes);
    }

    static <T> UriPathRouter<?, T> regEx(List<PathRoute<String, T>> routes) {
        return new UriPathRouter<Pattern, T>(Pattern::compile, RegexMatcher.getInstance(), routes);
    }

    static final class RegexMatcher<T>
    implements BiFunction<String, List<PathRoute<Pattern, T>>, T> {
        private static final RegexMatcher INSTANCE = new RegexMatcher();

        static <T> RegexMatcher<T> getInstance() {
            return INSTANCE;
        }

        private RegexMatcher() {
        }

        @Override
        public T apply(String path, List<PathRoute<Pattern, T>> routes) {
            for (PathRoute<Pattern, T> route : routes) {
                Pattern pattern = (Pattern)route.pattern;
                if (!pattern.matcher(path).matches()) continue;
                return (T)route.handler;
            }
            return null;
        }
    }

    static final class OrderedMatcher<T>
    implements BiFunction<String, List<PathRoute<String, T>>, T> {
        private static final OrderedMatcher INSTANCE = new OrderedMatcher();

        static <T> OrderedMatcher<T> getInstance() {
            return INSTANCE;
        }

        private OrderedMatcher() {
        }

        @Override
        public T apply(String path, List<PathRoute<String, T>> routes) {
            for (PathRoute<String, T> route : routes) {
                String pattern = (String)route.pattern;
                if (path.equals(pattern)) {
                    return (T)route.handler;
                }
                if (!PATH_PATTERN_MATCHER.match(pattern, path)) continue;
                return (T)route.handler;
            }
            return null;
        }
    }

    static final class BestMatcher<T>
    implements BiFunction<String, List<PathRoute<String, T>>, T> {
        private static final BestMatcher INSTANCE = new BestMatcher();

        static <T> BestMatcher<T> getInstance() {
            return INSTANCE;
        }

        private BestMatcher() {
        }

        @Override
        public T apply(String path, List<PathRoute<String, T>> routes) {
            PathRoute<String, T> bestMatch = null;
            for (PathRoute<String, T> route : routes) {
                if (((String)route.pattern).equals(path)) {
                    return (T)route.handler;
                }
                if (!PATH_PATTERN_MATCHER.match((String)route.pattern, path) || bestMatch != null && !PATH_PATTERN_MATCHER.isBetter((String)route.pattern, (String)bestMatch.pattern)) continue;
                bestMatch = route;
            }
            return bestMatch != null ? (T)bestMatch.handler : null;
        }
    }
}

