/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.lang.reflect.Member;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.4")
public final class ModifierSupport {
    private ModifierSupport() {
    }

    public static boolean isPublic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isPublic(clazz);
    }

    public static boolean isPublic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isPublic(member);
    }

    public static boolean isPrivate(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isPrivate(clazz);
    }

    public static boolean isPrivate(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isPrivate(member);
    }

    public static boolean isNotPrivate(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isNotPrivate(clazz);
    }

    public static boolean isNotPrivate(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isNotPrivate(member);
    }

    public static boolean isAbstract(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isAbstract(clazz);
    }

    public static boolean isAbstract(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isAbstract(member);
    }

    public static boolean isStatic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isStatic(clazz);
    }

    public static boolean isStatic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isStatic(member);
    }

    public static boolean isNotStatic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.isNotStatic(clazz);
    }

    public static boolean isNotStatic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return ReflectionUtils.isNotStatic(member);
    }
}

