/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.tools.serializer;

import java.io.IOException;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.tools.FunctionTool;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class FunctionToolJsonSerializer
extends StdSerializer<FunctionTool> {
    private static final String PYTHON_FUNC_TYPE = "PythonFunction";
    private static final String JAVA_FUNC_TYPE = "JavaFunction";

    public FunctionToolJsonSerializer() {
        super(FunctionTool.class);
    }

    @Override
    public void serialize(FunctionTool tool, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("metadata", tool.getMetadata());
        jsonGenerator.writeFieldName("function");
        if (tool.getFunction() instanceof JavaFunction) {
            JavaFunction javaFunction = (JavaFunction)tool.getFunction();
            this.serializeJavaFunction(jsonGenerator, javaFunction);
        } else if (tool.getFunction() instanceof PythonFunction) {
            PythonFunction pythonFunction = (PythonFunction)tool.getFunction();
            this.serializePythonFunction(jsonGenerator, pythonFunction);
        } else {
            throw new IllegalArgumentException("Unsupported function type: " + tool.getFunction().getClass().getName());
        }
        jsonGenerator.writeEndObject();
    }

    private void serializePythonFunction(JsonGenerator gen, PythonFunction func) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("func_type", PYTHON_FUNC_TYPE);
        gen.writeStringField("module", func.getModule());
        gen.writeStringField("qualname", func.getQualName());
        gen.writeEndObject();
    }

    private void serializeJavaFunction(JsonGenerator gen, JavaFunction func) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("func_type", JAVA_FUNC_TYPE);
        gen.writeStringField("qualname", func.getQualName());
        gen.writeStringField("method_name", func.getMethodName());
        gen.writeArrayFieldStart("parameter_types");
        for (Class<?> paramType : func.getParameterTypes()) {
            gen.writeString(paramType.getName());
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

