/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.serializer;

import java.io.IOException;
import org.apache.flink.agents.plan.resourceprovider.JavaResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.JavaSerializableResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.PythonResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.PythonSerializableResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.ResourceProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class ResourceProviderJsonSerializer
extends StdSerializer<ResourceProvider> {
    public ResourceProviderJsonSerializer() {
        super(ResourceProvider.class);
    }

    @Override
    public void serialize(ResourceProvider resourceProvider, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (resourceProvider instanceof PythonResourceProvider) {
            this.serializePythonResourceProvider(jsonGenerator, (PythonResourceProvider)resourceProvider);
        } else if (resourceProvider instanceof PythonSerializableResourceProvider) {
            this.serializePythonSerializableResourceProvider(jsonGenerator, (PythonSerializableResourceProvider)resourceProvider);
        } else if (resourceProvider instanceof JavaResourceProvider) {
            this.serializeJavaResourceProvider(jsonGenerator, (JavaResourceProvider)resourceProvider);
        } else if (resourceProvider instanceof JavaSerializableResourceProvider) {
            this.serializeJavaSerializableResourceProvider(jsonGenerator, (JavaSerializableResourceProvider)resourceProvider);
        } else {
            throw new IllegalArgumentException("Unsupported resource provider type: " + resourceProvider.getClass().getName());
        }
        jsonGenerator.writeEndObject();
    }

    private void serializePythonResourceProvider(JsonGenerator gen, PythonResourceProvider provider) throws IOException {
        gen.writeStringField("name", provider.getName());
        gen.writeStringField("type", provider.getType().getValue());
        gen.writeStringField("module", provider.getModule());
        gen.writeStringField("clazz", provider.getClazz());
        gen.writeFieldName("kwargs");
        gen.writeStartObject();
        provider.getKwargs().forEach((name, value) -> {
            try {
                gen.writeObjectField((String)name, value);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing kwargs of PythonResourceProvider: " + name, e);
            }
        });
        gen.writeEndObject();
        gen.writeStringField("__resource_provider_type__", "PythonResourceProvider");
    }

    private void serializePythonSerializableResourceProvider(JsonGenerator gen, PythonSerializableResourceProvider provider) throws IOException {
        gen.writeStringField("name", provider.getName());
        gen.writeStringField("type", provider.getType().getValue());
        gen.writeStringField("module", provider.getModule());
        gen.writeStringField("clazz", provider.getClazz());
        gen.writeFieldName("serialized");
        gen.writeStartObject();
        provider.getSerialized().forEach((name, value) -> {
            try {
                gen.writeObjectField((String)name, value);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing SerializableResource of PythonSerializableResourceProvider: " + name, e);
            }
        });
        gen.writeEndObject();
        gen.writeStringField("__resource_provider_type__", "PythonSerializableResourceProvider");
    }

    private void serializeJavaSerializableResourceProvider(JsonGenerator gen, JavaSerializableResourceProvider provider) throws IOException {
        gen.writeStringField("name", provider.getName());
        gen.writeStringField("type", provider.getType().getValue());
        gen.writeStringField("module", provider.getModule());
        gen.writeStringField("clazz", provider.getClazz());
        gen.writeStringField("serializedResource", provider.getSerializedResource());
        gen.writeStringField("__resource_provider_type__", JavaSerializableResourceProvider.class.getSimpleName());
    }

    private void serializeJavaResourceProvider(JsonGenerator gen, JavaResourceProvider provider) throws IOException {
        gen.writeStringField("name", provider.getName());
        gen.writeStringField("type", provider.getType().getValue());
        gen.writeObjectField("descriptor", provider.getDescriptor());
        gen.writeStringField("__resource_provider_type__", JavaResourceProvider.class.getSimpleName());
    }
}

