/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.ollama4j.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OllamaResult {
    private final String response;
    private final String thinking;
    private int httpStatusCode;
    private long responseTime = 0L;
    private String model;
    private String createdAt;
    private boolean done;
    private String doneReason;
    private List<Integer> context;
    private Long totalDuration;
    private Long loadDuration;
    private Integer promptEvalCount;
    private Long promptEvalDuration;
    private Integer evalCount;
    private Long evalDuration;

    public OllamaResult(String response, String thinking, long responseTime, int httpStatusCode) {
        this.response = response;
        this.thinking = thinking;
        this.responseTime = responseTime;
        this.httpStatusCode = httpStatusCode;
    }

    public String toString() {
        try {
            HashMap<String, Object> responseMap = new HashMap<String, Object>();
            responseMap.put("response", this.response);
            responseMap.put("thinking", this.thinking);
            responseMap.put("httpStatusCode", this.httpStatusCode);
            responseMap.put("responseTime", this.responseTime);
            responseMap.put("model", this.model);
            responseMap.put("createdAt", this.createdAt);
            responseMap.put("done", this.done);
            responseMap.put("doneReason", this.doneReason);
            responseMap.put("context", this.context);
            responseMap.put("totalDuration", this.totalDuration);
            responseMap.put("loadDuration", this.loadDuration);
            responseMap.put("promptEvalCount", this.promptEvalCount);
            responseMap.put("promptEvalDuration", this.promptEvalDuration);
            responseMap.put("evalCount", this.evalCount);
            responseMap.put("evalDuration", this.evalDuration);
            return Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(responseMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getStructuredResponse() {
        String responseStr = this.getResponse();
        if (responseStr == null || responseStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Response is empty or null");
        }
        try {
            if (!responseStr.trim().startsWith("{") && !responseStr.trim().startsWith("[") || !responseStr.trim().endsWith("}") && !responseStr.trim().endsWith("]")) {
                throw new IllegalArgumentException("Response is not a valid JSON object");
            }
            Map<String, Object> response = Utils.getObjectMapper().readValue(responseStr, new TypeReference<Map<String, Object>>(){});
            return response;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to parse response as JSON: " + e.getMessage(), e);
        }
    }

    public <T> T as(Class<T> clazz) {
        String responseStr = this.getResponse();
        if (responseStr == null || responseStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Response is empty or null");
        }
        try {
            if (!responseStr.trim().startsWith("{") && !responseStr.trim().startsWith("[") || !responseStr.trim().endsWith("}") && !responseStr.trim().endsWith("]")) {
                throw new IllegalArgumentException("Response is not a valid JSON object");
            }
            return Utils.getObjectMapper().readValue(responseStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to parse response as JSON: " + e.getMessage(), e);
        }
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public String getThinking() {
        return this.thinking;
    }

    @Generated
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Generated
    public long getResponseTime() {
        return this.responseTime;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public boolean isDone() {
        return this.done;
    }

    @Generated
    public String getDoneReason() {
        return this.doneReason;
    }

    @Generated
    public List<Integer> getContext() {
        return this.context;
    }

    @Generated
    public Long getTotalDuration() {
        return this.totalDuration;
    }

    @Generated
    public Long getLoadDuration() {
        return this.loadDuration;
    }

    @Generated
    public Integer getPromptEvalCount() {
        return this.promptEvalCount;
    }

    @Generated
    public Long getPromptEvalDuration() {
        return this.promptEvalDuration;
    }

    @Generated
    public Integer getEvalCount() {
        return this.evalCount;
    }

    @Generated
    public Long getEvalDuration() {
        return this.evalDuration;
    }

    @Generated
    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    @Generated
    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setDone(boolean done) {
        this.done = done;
    }

    @Generated
    public void setDoneReason(String doneReason) {
        this.doneReason = doneReason;
    }

    @Generated
    public void setContext(List<Integer> context) {
        this.context = context;
    }

    @Generated
    public void setTotalDuration(Long totalDuration) {
        this.totalDuration = totalDuration;
    }

    @Generated
    public void setLoadDuration(Long loadDuration) {
        this.loadDuration = loadDuration;
    }

    @Generated
    public void setPromptEvalCount(Integer promptEvalCount) {
        this.promptEvalCount = promptEvalCount;
    }

    @Generated
    public void setPromptEvalDuration(Long promptEvalDuration) {
        this.promptEvalDuration = promptEvalDuration;
    }

    @Generated
    public void setEvalCount(Integer evalCount) {
        this.evalCount = evalCount;
    }

    @Generated
    public void setEvalDuration(Long evalDuration) {
        this.evalDuration = evalDuration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaResult)) {
            return false;
        }
        OllamaResult other = (OllamaResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpStatusCode() != other.getHttpStatusCode()) {
            return false;
        }
        if (this.getResponseTime() != other.getResponseTime()) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        Long this$totalDuration = this.getTotalDuration();
        Long other$totalDuration = other.getTotalDuration();
        if (this$totalDuration == null ? other$totalDuration != null : !((Object)this$totalDuration).equals(other$totalDuration)) {
            return false;
        }
        Long this$loadDuration = this.getLoadDuration();
        Long other$loadDuration = other.getLoadDuration();
        if (this$loadDuration == null ? other$loadDuration != null : !((Object)this$loadDuration).equals(other$loadDuration)) {
            return false;
        }
        Integer this$promptEvalCount = this.getPromptEvalCount();
        Integer other$promptEvalCount = other.getPromptEvalCount();
        if (this$promptEvalCount == null ? other$promptEvalCount != null : !((Object)this$promptEvalCount).equals(other$promptEvalCount)) {
            return false;
        }
        Long this$promptEvalDuration = this.getPromptEvalDuration();
        Long other$promptEvalDuration = other.getPromptEvalDuration();
        if (this$promptEvalDuration == null ? other$promptEvalDuration != null : !((Object)this$promptEvalDuration).equals(other$promptEvalDuration)) {
            return false;
        }
        Integer this$evalCount = this.getEvalCount();
        Integer other$evalCount = other.getEvalCount();
        if (this$evalCount == null ? other$evalCount != null : !((Object)this$evalCount).equals(other$evalCount)) {
            return false;
        }
        Long this$evalDuration = this.getEvalDuration();
        Long other$evalDuration = other.getEvalDuration();
        if (this$evalDuration == null ? other$evalDuration != null : !((Object)this$evalDuration).equals(other$evalDuration)) {
            return false;
        }
        String this$response = this.getResponse();
        String other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$thinking = this.getThinking();
        String other$thinking = other.getThinking();
        if (this$thinking == null ? other$thinking != null : !this$thinking.equals(other$thinking)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$doneReason = this.getDoneReason();
        String other$doneReason = other.getDoneReason();
        if (this$doneReason == null ? other$doneReason != null : !this$doneReason.equals(other$doneReason)) {
            return false;
        }
        List<Integer> this$context = this.getContext();
        List<Integer> other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OllamaResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHttpStatusCode();
        long $responseTime = this.getResponseTime();
        result = result * 59 + (int)($responseTime >>> 32 ^ $responseTime);
        result = result * 59 + (this.isDone() ? 79 : 97);
        Long $totalDuration = this.getTotalDuration();
        result = result * 59 + ($totalDuration == null ? 43 : ((Object)$totalDuration).hashCode());
        Long $loadDuration = this.getLoadDuration();
        result = result * 59 + ($loadDuration == null ? 43 : ((Object)$loadDuration).hashCode());
        Integer $promptEvalCount = this.getPromptEvalCount();
        result = result * 59 + ($promptEvalCount == null ? 43 : ((Object)$promptEvalCount).hashCode());
        Long $promptEvalDuration = this.getPromptEvalDuration();
        result = result * 59 + ($promptEvalDuration == null ? 43 : ((Object)$promptEvalDuration).hashCode());
        Integer $evalCount = this.getEvalCount();
        result = result * 59 + ($evalCount == null ? 43 : ((Object)$evalCount).hashCode());
        Long $evalDuration = this.getEvalDuration();
        result = result * 59 + ($evalDuration == null ? 43 : ((Object)$evalDuration).hashCode());
        String $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $thinking = this.getThinking();
        result = result * 59 + ($thinking == null ? 43 : $thinking.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $doneReason = this.getDoneReason();
        result = result * 59 + ($doneReason == null ? 43 : $doneReason.hashCode());
        List<Integer> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }
}

