/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.javaxwrappers;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionTrackingMode;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.felix.http.javaxwrappers.FilterRegistrationWrapper;
import org.apache.felix.http.javaxwrappers.RequestDispatcherWrapper;
import org.apache.felix.http.javaxwrappers.ServletRegistrationWrapper;
import org.apache.felix.http.javaxwrappers.SessionCookieConfigWrapper;
import org.jetbrains.annotations.NotNull;

public class ServletContextWrapper
implements javax.servlet.ServletContext {
    private final ServletContext context;

    public ServletContextWrapper(@NotNull ServletContext c) {
        this.context = c;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public javax.servlet.ServletContext getContext(String uripath) {
        ServletContext c = this.context.getContext(uripath);
        if (c != null) {
            return new ServletContextWrapper(c);
        }
        return null;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        jakarta.servlet.RequestDispatcher dispatcher = this.context.getRequestDispatcher(path);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        jakarta.servlet.RequestDispatcher dispatcher = this.context.getNamedDispatcher(name);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getServletNames() {
        return Collections.emptyEnumeration();
    }

    public void log(String msg) {
        this.context.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.context.log(msg, (Throwable)exception);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public javax.servlet.ServletRegistration getServletRegistration(String servletName) {
        ServletRegistration reg = this.context.getServletRegistration(servletName);
        if (reg != null) {
            return new ServletRegistrationWrapper(reg);
        }
        return null;
    }

    public Map<String, ? extends javax.servlet.ServletRegistration> getServletRegistrations() {
        HashMap result = new HashMap();
        for (Map.Entry e : this.context.getServletRegistrations().entrySet()) {
            result.put(e.getKey(), new ServletRegistrationWrapper((ServletRegistration)e.getValue()));
        }
        return result;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        jakarta.servlet.FilterRegistration reg = this.context.getFilterRegistration(filterName);
        if (reg != null) {
            return new FilterRegistrationWrapper(reg);
        }
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        HashMap result = new HashMap();
        for (Map.Entry e : this.context.getFilterRegistrations().entrySet()) {
            result.put(e.getKey(), new FilterRegistrationWrapper((jakarta.servlet.FilterRegistration)e.getValue()));
        }
        return result;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return new SessionCookieConfigWrapper(this.context.getSessionCookieConfig());
    }

    public void setSessionTrackingModes(Set<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes == null) {
            this.context.setSessionTrackingModes(null);
        } else {
            HashSet<SessionTrackingMode> modes = new HashSet<SessionTrackingMode>();
            if (sessionTrackingModes.contains(javax.servlet.SessionTrackingMode.COOKIE)) {
                modes.add(SessionTrackingMode.COOKIE);
            }
            if (sessionTrackingModes.contains(javax.servlet.SessionTrackingMode.SSL)) {
                modes.add(SessionTrackingMode.SSL);
            }
            if (sessionTrackingModes.contains(javax.servlet.SessionTrackingMode.URL)) {
                modes.add(SessionTrackingMode.URL);
            }
            this.context.setSessionTrackingModes(modes);
        }
    }

    public Set<javax.servlet.SessionTrackingMode> getDefaultSessionTrackingModes() {
        Set sessionTrackingModes = this.context.getDefaultSessionTrackingModes();
        HashSet<javax.servlet.SessionTrackingMode> modes = new HashSet<javax.servlet.SessionTrackingMode>();
        if (sessionTrackingModes.contains(SessionTrackingMode.COOKIE)) {
            modes.add(javax.servlet.SessionTrackingMode.COOKIE);
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            modes.add(javax.servlet.SessionTrackingMode.SSL);
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.URL)) {
            modes.add(javax.servlet.SessionTrackingMode.URL);
        }
        return modes;
    }

    public Set<javax.servlet.SessionTrackingMode> getEffectiveSessionTrackingModes() {
        Set sessionTrackingModes = this.context.getEffectiveSessionTrackingModes();
        HashSet<javax.servlet.SessionTrackingMode> modes = new HashSet<javax.servlet.SessionTrackingMode>();
        if (sessionTrackingModes.contains(SessionTrackingMode.COOKIE)) {
            modes.add(javax.servlet.SessionTrackingMode.COOKIE);
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            modes.add(javax.servlet.SessionTrackingMode.SSL);
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.URL)) {
            modes.add(javax.servlet.SessionTrackingMode.URL);
        }
        return modes;
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException();
    }

    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.context.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.context.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.context.setResponseCharacterEncoding(encoding);
    }
}

