/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl.external.certificate;

import javax.security.sasl.SaslServer;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.external.certificate.ExternalSaslServer;

public class CertificateMechanismHandler
extends AbstractMechanismHandler {
    @Override
    public SaslServer handleMechanism(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            String saslHost = ldapSession.getLdapServer().getSaslHost();
            String userBaseDn = ldapSession.getLdapServer().getSearchBaseDn();
            ldapSession.putSaslProperty("host", saslHost);
            ldapSession.putSaslProperty("userBaseDn", userBaseDn);
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            ss = new ExternalSaslServer(ldapSession, adminSession, bindRequest);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    @Override
    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        ldapSession.putSaslProperty("host", saslHost);
    }

    @Override
    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

