/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.startTransaction;

import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.startTransaction.StartTransactionResponse;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;

public class StartTransactionResponseImpl
extends AbstractExtendedResponse
implements StartTransactionResponse {
    private byte[] transactionId;

    public StartTransactionResponseImpl(int messageId, ResultCodeEnum resultCode, byte[] transactionId) {
        super(messageId);
        switch (resultCode) {
            case SUCCESS: {
                this.transactionId = Strings.copy((byte[])transactionId);
                break;
            }
            case CANCELED: 
            case CANNOT_CANCEL: 
            case NO_SUCH_OPERATION: 
            case TOO_LATE: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13503_RESULT_CODE_SHOULD_BE_IN, (Object[])new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(resultCode);
    }

    public StartTransactionResponseImpl(int messageId, byte[] transactionId) {
        super(messageId);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        this.transactionId = Strings.copy((byte[])transactionId);
    }

    public StartTransactionResponseImpl(byte[] transactionId) {
        super("1.3.6.1.1.21.1");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        this.transactionId = Strings.copy((byte[])transactionId);
    }

    public StartTransactionResponseImpl() {
        super("1.3.6.1.1.21.1");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public int hashCode() {
        int hash = 37;
        if (this.transactionId != null) {
            for (byte b : this.transactionId) {
                hash += hash * 17 + b;
            }
        }
        hash = hash * 17 + this.getClass().getName().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StartTransactionResponseImpl)) {
            return false;
        }
        return Arrays.equals(this.transactionId, ((StartTransactionResponseImpl)obj).transactionId);
    }

    @Override
    public byte[] getTransactionId() {
        return Strings.copy((byte[])this.transactionId);
    }

    public void setTransactionId(byte[] transactionId) {
        this.transactionId = Strings.copy((byte[])transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StartTransactionResponse :");
        sb.append("\n    transactionID : ");
        if (this.transactionId != null) {
            sb.append(Strings.dumpBytes((byte[])this.transactionId));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

