/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.scheduler.impl;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.scheduler.spi.SchedulerControl;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractJobAdapter<T>
implements Job {
    private static final Logger LOG = Logger.getLogger(AbstractJobAdapter.class.getName());
    @Inject
    private BeanManager beanManager;

    public void execute(JobExecutionContext context) {
        Class jobClass = ClassUtils.tryToLoadClassForName((String)context.getJobDetail().getKey().getName(), this.getJobBaseClass());
        SchedulerControl schedulerControl = (SchedulerControl)BeanProvider.getContextualReference(SchedulerControl.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (schedulerControl != null && schedulerControl.vetoJobExecution(jobClass)) {
            LOG.info("Execution of job " + jobClass + " has been vetoed by " + ProxyUtils.getUnproxiedClass(schedulerControl.getClass()));
            return;
        }
        Object job = BeanProvider.getContextualReference((Class)jobClass, (Annotation[])new Annotation[0]);
        try {
            this.execute(job, context);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error while executing job " + jobClass, t);
        }
    }

    protected abstract Class<T> getJobBaseClass();

    public abstract void execute(T var1, JobExecutionContext var2) throws JobExecutionException;
}

