/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.phase;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Vetoed;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.view.controller.InitView;
import org.apache.deltaspike.core.api.config.view.controller.PostRenderView;
import org.apache.deltaspike.core.api.config.view.controller.PreRenderView;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.jsf.impl.listener.phase.JsfRequestLifecyclePhaseListener;
import org.apache.deltaspike.jsf.impl.listener.phase.WindowMetaData;
import org.apache.deltaspike.jsf.impl.security.ViewRootAccessHandler;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.apache.deltaspike.jsf.impl.util.SecurityUtils;
import org.apache.deltaspike.jsf.impl.util.ViewControllerUtils;
import org.apache.deltaspike.security.api.authorization.ErrorViewAwareAccessDeniedException;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;

@Vetoed
public class DeltaSpikePhaseListener
implements PhaseListener,
Deactivatable {
    private static final long serialVersionUID = -4458288760053069922L;
    private final boolean activated;
    private Boolean securityModuleActivated;
    private final PhaseListener jsfRequestLifecyclePhaseListener = new JsfRequestLifecyclePhaseListener();
    private volatile ViewConfigResolver viewConfigResolver;

    public DeltaSpikePhaseListener() {
        this.activated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (!this.activated) {
            return;
        }
        if (this.viewConfigResolver == null) {
            this.lazyInit();
        }
        this.processInitView(phaseEvent);
        this.jsfRequestLifecyclePhaseListener.beforePhase(phaseEvent);
        if (PhaseId.RENDER_RESPONSE.equals(phaseEvent.getPhaseId())) {
            this.onBeforeRenderResponse(phaseEvent.getFacesContext());
        }
    }

    private void onBeforeRenderResponse(FacesContext facesContext) {
        this.checkSecuredView(facesContext);
        this.processPreRenderView(facesContext);
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (!this.activated) {
            return;
        }
        if (this.viewConfigResolver == null) {
            this.lazyInit();
        }
        this.processInitView(phaseEvent);
        if (PhaseId.RESTORE_VIEW.equals(phaseEvent.getPhaseId())) {
            this.onAfterRestoreView(phaseEvent.getFacesContext());
        } else if (PhaseId.RENDER_RESPONSE.equals(phaseEvent.getPhaseId())) {
            this.onAfterRenderResponse(phaseEvent.getFacesContext());
        }
        this.jsfRequestLifecyclePhaseListener.afterPhase(phaseEvent);
    }

    private void onAfterRestoreView(FacesContext facesContext) {
        JsfUtils.tryToRestoreMessages(facesContext);
    }

    private void onAfterRenderResponse(FacesContext facesContext) {
        this.processPostRenderView(facesContext);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void checkSecuredView(FacesContext facesContext) {
        if (!this.securityModuleActivated.booleanValue()) {
            return;
        }
        try {
            ((ViewRootAccessHandler)BeanProvider.getContextualReference(ViewRootAccessHandler.class, (Annotation[])new Annotation[0])).checkAccessTo(facesContext.getViewRoot());
        }
        catch (ErrorViewAwareAccessDeniedException accessDeniedException) {
            SecurityUtils.tryToHandleSecurityViolation((RuntimeException)((Object)accessDeniedException));
            facesContext.renderResponse();
        }
    }

    private synchronized void lazyInit() {
        if (this.viewConfigResolver != null) {
            return;
        }
        this.securityModuleActivated = BeanProvider.getContextualReference(EditableAccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]) != null;
        this.viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0]);
        if (!this.securityModuleActivated.booleanValue()) {
            Logger.getLogger(this.getClass().getName()).info("security-module-impl isn't used -> " + this.getClass().getName() + "#checkSecuredView gets deactivated");
        }
    }

    private void processInitView(PhaseEvent event) {
        if (event.getPhaseId().equals(PhaseId.RESTORE_VIEW) && !this.isRedirectRequest(event.getFacesContext())) {
            return;
        }
        FacesContext facesContext = event.getFacesContext();
        if (facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId() != null) {
            this.processInitView(event.getFacesContext().getViewRoot().getViewId());
        }
    }

    private void processInitView(String viewId) {
        try {
            WindowMetaData windowMetaData = (WindowMetaData)BeanProvider.getContextualReference(WindowMetaData.class, (Annotation[])new Annotation[0]);
            if (viewId.equals(windowMetaData.getInitializedViewId())) {
                return;
            }
            windowMetaData.setInitializedViewId(viewId);
            ViewConfigDescriptor viewDefinitionEntry = this.viewConfigResolver.getViewConfigDescriptor(viewId);
            if (viewDefinitionEntry == null) {
                return;
            }
            ViewControllerUtils.executeViewControllerCallback(viewDefinitionEntry, InitView.class);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
    }

    private void processPreRenderView(FacesContext facesContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            ViewConfigDescriptor viewDefinitionEntry = this.viewConfigResolver.getViewConfigDescriptor(uiViewRoot.getViewId());
            ViewControllerUtils.executeViewControllerCallback(viewDefinitionEntry, PreRenderView.class);
        }
    }

    private void processPostRenderView(FacesContext facesContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            ViewConfigDescriptor viewDefinitionEntry = this.viewConfigResolver.getViewConfigDescriptor(uiViewRoot.getViewId());
            ViewControllerUtils.executeViewControllerCallback(viewDefinitionEntry, PostRenderView.class);
        }
    }

    private boolean isRedirectRequest(FacesContext facesContext) {
        return facesContext.getResponseComplete();
    }
}

