/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.exception.control;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.SystemEvent;
import java.util.Iterator;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.apache.deltaspike.jsf.impl.util.SecurityUtils;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.ErrorViewAwareAccessDeniedException;

public class BridgeExceptionHandlerWrapper
extends ExceptionHandlerWrapper
implements Deactivatable {
    private final ExceptionHandler wrapped;

    public BridgeExceptionHandlerWrapper(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null || context.getResponseComplete()) {
            return;
        }
        Iterable exceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents();
        if (exceptionQueuedEvents != null && exceptionQueuedEvents.iterator() != null) {
            Iterator iterator = exceptionQueuedEvents.iterator();
            while (iterator.hasNext()) {
                Throwable throwable = ((ExceptionQueuedEvent)iterator.next()).getContext().getException();
                Throwable rootCause = this.getRootCause(throwable);
                if (rootCause instanceof AccessDeniedException) {
                    this.processAccessDeniedException(rootCause);
                    iterator.remove();
                    continue;
                }
                if (!context.getResponseComplete()) continue;
                break;
            }
        }
        super.handle();
    }

    public Throwable getRootCause(Throwable throwable) {
        return JsfUtils.getRootCause(throwable);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        Throwable exception;
        ExceptionQueuedEvent exceptionQueuedEvent;
        FacesContext facesContext;
        if (event instanceof ExceptionQueuedEvent && (facesContext = (exceptionQueuedEvent = (ExceptionQueuedEvent)event).getContext().getContext()).getCurrentPhaseId() == PhaseId.RENDER_RESPONSE && exceptionQueuedEvent.getContext().inBeforePhase() && (exception = this.getRootCause(exceptionQueuedEvent.getContext().getException())) instanceof AccessDeniedException) {
            this.processAccessDeniedException(exception);
        }
        super.processEvent(event);
    }

    private void processAccessDeniedException(Throwable throwable) {
        if (throwable instanceof ErrorViewAwareAccessDeniedException) {
            SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)((AccessDeniedException)throwable));
        } else {
            ErrorViewAwareAccessDeniedException securityException = new ErrorViewAwareAccessDeniedException(((AccessDeniedException)throwable).getViolations(), DefaultErrorView.class);
            SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)((Object)securityException));
        }
    }
}

