/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.CacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;

public abstract class AbstractAuxiliaryCache<K, V>
implements AuxiliaryCache<K, V> {
    private ICacheEventLogger cacheEventLogger;
    private IElementSerializer elementSerializer = new StandardSerializer();
    private IKeyMatcher<K> keyMatcher = new KeyMatcherPatternImpl();

    protected ICacheEvent<K> createICacheEvent(ICacheElement<K, V> item, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String diskLocation = this.getEventLoggingExtraInfo();
        String regionName = null;
        Object key = null;
        if (item != null) {
            regionName = item.getCacheName();
            key = item.getKey();
        }
        return this.cacheEventLogger.createICacheEvent(this.getAuxiliaryCacheAttributes().getName(), regionName, eventName, diskLocation, key);
    }

    protected <T> ICacheEvent<T> createICacheEvent(String regionName, T key, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String diskLocation = this.getEventLoggingExtraInfo();
        return this.cacheEventLogger.createICacheEvent(this.getAuxiliaryCacheAttributes().getName(), regionName, eventName, diskLocation, key);
    }

    protected <T> void logICacheEvent(ICacheEvent<T> cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected void logError(String source, String eventName, String errorMessage) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logError(source, eventName, errorMessage);
        }
    }

    public abstract String getEventLoggingExtraInfo();

    @Override
    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }

    public ICacheEventLogger getCacheEventLogger() {
        return this.cacheEventLogger;
    }

    @Override
    public void setElementSerializer(IElementSerializer elementSerializer) {
        if (elementSerializer != null) {
            this.elementSerializer = elementSerializer;
        }
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    @Override
    public void setKeyMatcher(IKeyMatcher<K> keyMatcher) {
        if (keyMatcher != null) {
            this.keyMatcher = keyMatcher;
        }
    }

    public IKeyMatcher<K> getKeyMatcher() {
        return this.keyMatcher;
    }
}

